#! /usr/bin/sh
# (Fait par Hubert Lesage et Philippe Saint-Loup Tel 45224)
#---------------------------------
# Parametres modifiables
#
LOGFILE='/tmp/verif_os_sar.dpst.log'
SEUIL_NFILE=80
SEUIL_NPROC=80
#
#---------------------------------
# Initialisation du PATH
#
PATH=$PATH:/usr/contrib/bin:/sbin:/usr/sbin
export PATH
#
#----------------------------------------------------------
# Determination de la limite des fichiers et process ouverts
#
CMD=`sar -v 1 1 | tail -1 `
NFILE=`echo $CMD | awk '{print $8}'`
NPROC=`echo $CMD | awk '{print $4}'`
RATIO_NFILE=`echo $NFILE | awk '{FS="/"; OFMT="%3.0f"; print ($1/$2)*100}'`
RATIO_NPROC=`echo $NPROC | awk '{FS="/"; OFMT="%3.0f"; print ($1/$2)*100}'`
FLAG=0
#
#
#----------------------------------------------------------
# Historisation pour DPST
#
SYSDATE=`/usr/bin/date '+%Y/%m/%d %X:%Z'`
[ -s "$LOGFILE" ] || echo "DATE \t\t\t\t PROC_SZ  % \t FILE_SZ  %" >> $LOGFILE 
echo "$SYSDATE \t $NFILE $RATIO_NFILE \t $NPROC $RATIO_NPROC" >> $LOGFILE
#
#------------------------------------------------------
# Envoi d alerte si le ratio est superieur a SEUIL
#
if (("$RATIO_NFILE" > "$SEUIL_NFILE" ))
then
	echo "nfile....................KO <<<<<<<<<<<<<<<<<<<<<"
	echo "		Le nombre de fichiers (${NFILE}) ouverts a depasse le seuil de $SEUIL_NFILE %"
	FLAG=1
else
	echo "nfile....................OK"
fi
#
if (( "$RATIO_NPROC" > "$SEUIL_NPROC" ))
then 
	echo "nproc....................KO <<<<<<<<<<<<<<<<<<<<<"
	echo "		Le nombre de processus (${NPROC}) a depasse le seuil de $SEUIL_NPROC %"
	FLAG=1
else
	echo "nproc....................OK"
fi

if (( ${FLAG} == 1 ))
then
	echo "Parametres systeme...............KO <<<<<<<<<<<<<<<<<<<"
else
	echo "Parametres systeme...............OK"
fi

exit ${FLAG}

# eof
