select 'TBO-00001 Manque place tablespace', f.tablespace_name 
from sys.dba_data_files f, sys.dba_free_space s 
where f.tablespace_name = s.tablespace_name
group by f.tablespace_name 
having trunc(((sum(s.bytes)/count(distinct f.file_id))*100)/
 (sum(f.bytes)/count(distinct s.file_id||s.block_id)),2)  <10 
;
select 'TBO-00002 Obj trop frag', segment_type, segment_name,extents
from sys.dba_segments
where
( extents > (max_extents*0.8) or extents > 100 )
 and segment_type in ('INDEX','TABLE')
;
select 'TBO-00003 Limite nb process'
from v$parameter
where name ='processes'
and value-5 < (select count(*) from v$process) 
;
select 'TBO-00004 Limite nb transac'
from v$parameter
where name ='transactions'
and value-5 < (select sum(xacts) from v$rollstat)
;
select 'TBO-00005 Manque place rollback dans tablespace',
c.tablespace_name
from v$rollname a,v$rollstat b,sys.dba_rollback_segs c,sys.dba_data_files d
where a.usn          = b.usn
and   c.segment_name = a.name
and c.tablespace_name=d.tablespace_name
and d.tablespace_name not like 'ROLL%'
and d.tablespace_name not like 'TEMP%'
group by c.tablespace_name
having
(
sum(extends)/count(distinct d.file_id) >0 and
sum(hwmsize)/count(distinct d.file_id) >0.8*sum(d.bytes)/count(distinct b.usn)
)
;
select 'TBO-00006 '||f.tablespace_name||' encore en cours de sauvegarde ?'
from v$backup b,dba_data_files f
where b.file#=f.file_id
and b.status='ACTIVE'
and to_number(to_char(sysdate,'HH24')) between 9 and 16
group by f.tablespace_name
;
select 'TBO-00007 Shared Pool trop petite ou fragmentee'
from v$librarycache l, v$shared_pool_reserved s
group by request_failures
having ( 1 - (sum(l.reloads)/sum(l.pins)) < 0.90 )
or (request_failures >0)
/* reloads = Nb objets montM-is en sga puis redescendus par manque de place */
/* request_failures = nb erreurs 4031 */
;
