#!/serveur/dp/bin/perl -w

# ---------------------------------------------------------------
#
# Surveillance de XLV sous IRIX
#		
# usage : XLVMGR_sur.pl nom_template
#
# Code retour :
#		0 : ok, 2 : alarme ITO
#
# exemple : XLVMGR_sur.pl XLVMGR_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# Recherche les metadevices en erreur
# ---------------------------------------------------------------

sub Traitement {
	Trace "TraiteXLV" if($debug);
	my ($volume,$etat);
	my $commentaire = "Tout est ok\n";
	my $code = 0;
	my @result = xlvmgr('-c "show -long all" 2>&1');
	for(@result) {
			my $ligne = $_;
			if($ligne =~ /^VOL\s+(\w+)\s+\((\w+|\w+\s\w+\s\w+)\)/){
				my $volume = $1;
				my $etat = $2 ;
				if ($etat ne "complete"){
					$commentaire = "Etat de $volume : $etat\n";
					$code = 2;
				}
			}
		}
	print "$commentaire";
	return $code
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
	
