#!/serveur/dp/bin/perl -w

# 	$Id: TIV_node.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance de la connexion des noeuds Tivoli.
#
# usage : TIV_node.pl <nom_template>
#
# Code retour :
#		renvoie le nombre de nodes non connectes, => pb si > 0
#
# exemple : TIV_node.pl TIV_node
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;
use Fcntl ':flock';

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my $log = "/var/tmp/opc_tivnode.log";

my $NbrPing = 5;		# Nombre de PING a effectuer sur chaque node KO
my $MaxPing = 2;		# Nombre de series de WPING a effectuer
my %ok;

# ---------------------------------------------------------------
# stocke sortie dans fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	print LOG @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# renvoie le % de paquets reus
# Les options de ping ne sont valables que pour Solaris
# ---------------------------------------------------------------
sub pping {
	my ($node) = @_;
	print "/usr/sbin/ping -s $node 64 $NbrPing 2>&1\n" if($debug);
	chomp(my($Retour) = grep(/packets transmitted/,ping("-s $node 64 $NbrPing")));
	my($transmitted,$received) = ($NbrPing,0);
	($transmitted,$received) = ($1,$2) if($Retour =~ /(\d+) packets transmitted, (\d+)/);
	return $received*100/$transmitted;
}

# ---------------------------------------------------------------
# Rcuperation du numero de la TMR.
# Construit un tableau de tous les ManagedNodes de la TMR.
# Lance un wping sur chaque node
# Fait un PING sur les nodes KO
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	my $i;
	my $NodeKo = 0;
	my $TMR;
	unlink $log if(-f $log);

	my($TmrNumber) = objcall("0.0.0 get_oserv");
	($TmrNumber) = split(/\./,$TmrNumber);
	print "$TmrNumber\n" if($debug);
	my @tableau = grep(/$TmrNumber/,wlookup("-ar ManagedNode"));
	for(@tableau)	{
		my($node) = split (/\s+/);
		$TMR = $node if(/$TmrNumber\.1\./);
		$ok{$node} = 0;
	}
	Log "\nTMR verifiee : $TMR ($TmrNumber)\n";
	Log "\nNombre de serveurs trouves : ", scalar( @tableau ),"\n\n";

	for($i=0;$i<$MaxPing;$i++) {
		for(sort keys %ok)	{
			my($node) = $_;
			next if($ok{$node});
			print "wping $node\n" if($debug);
			my($ping) = wping("$node 2>&1");
			$ok{$node} = 1 if($ping =~ /is alive/);
		}
	}

	for(sort keys %ok) {
		if(! $ok{$_}) {
			my $Node = $_;
			$NodeKo++;
			Log "------------------------------------------------------------\n";
			Log "Le serveur : $Node est KO par wping (connexion Tivoli),\n";
			my $pourcent = pping($Node);
			if($pourcent<100) {
				Log "mais est OK par ping.\n";
				Log "C'est donc un probleme Tivoli.\n";
			} else {
				Log "et egalement KO par ping ($pourcent% recus).\n";
				Log "C'est donc un probleme reseau, et non Tivoli.\n";
			}
			Log "------------------------------------------------------------\n";
		}
	}
	Log "\nNombre de serveur(s) KO : $NodeKo\n\n";
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__

