#!/serveur/dp/bin/perl -w

# 	$Id: SDS_sur.pl,v 2.1 2000/09/13 06:08:26 legranau Exp $	

# ---------------------------------------------------------------
#
# Surveillance des metadevices Solstice Disk Suite
#
# Fonctionne galement pour les clusters avec vrification
# si besoin est du metaset de la machine.
#		
# usage : SDS_sur.pl nom_template
#
# Code retour :
#		0 : ok, 2 : alarme ITO
#
# exemple : SDS_sur.pl SDS_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my (%table,%device,%type);

# ---------------------------------------------------------------
# stocke les erreurs
# ---------------------------------------------------------------
sub ajout {
	my($device,$state) = @_;
	Trace "device=$device state=$state" if($debug);
	$table{$device} = $state if($state !~ /^(Okay|Resyncing)\s*$/);
}

# ---------------------------------------------------------------
# Renvoie les noms de diskset s'il y en a
# ---------------------------------------------------------------
sub SetNames {
	my @noms;
	my($code,@metaset) = metaset("2>&1");
	if(!@metaset || $metaset[0] =~ /there are no existing/) {
		print "there are no existing metaset\n";
	} else {
		if($code!=0 && $code!=256 && @metaset) {
			Trace "Erreur lors de l'execution du metaset : code=$code : @metaset";
		} elsif(@metaset) {
			for(@metaset) {
				push(@noms,$1) if(/Set name = (\S+),/);
			}
		}
	}
	return @noms;
}

# ---------------------------------------------------------------
# Recherche les replicas en erreur
# ---------------------------------------------------------------
sub TraiteMetadb {
	Trace "TraiteMetadb" if($debug);
	my @result;
	my @metaset = SetNames();
	for(@metaset) {
		my $set = $_;
		my($code,@result1) = metadb("-i -s $set 2>&1");
		@result = (@result,@result1);
	}
	my($code,@result1) = metadb("-i 2>&1");
	if(!@result1 || $result1[0] =~ /there are no existing databases/) {
		print "there are no existing databases\n";
	} else {
		Trace "Erreur lors de l'execution du metadb : @result1" if($code != 0);
		@result = (@result,@result1);
		for(@result) {
			if(/^\s+(.+)\s+\w+\s+\w+\s+\/dev(\S+)$/) {
				my ($flags,$device) = ($1,basename($2));
				ajout($device,"replica has device write errors") if($flags =~ /W/);
				ajout($device,"replica had problem with master blocks") if($flags =~ /M/);
				ajout($device,"replica had problem with data blocks") if($flags =~ /D/);
				ajout($device,"replica had format problems") if($flags =~ /F/);
				ajout($device,"replica is too small to hold current data base") if($flags =~ /S/);
				ajout($device,"replica had device read errors") if($flags =~ /R/);
			}
		}
	}
}

# ---------------------------------------------------------------
# Recherche les metadevices en erreur
# ---------------------------------------------------------------
sub TraiteMetadevice {
	Trace "TraiteMetadevice" if($debug);
	my @result;
	my @metaset = SetNames();
	for(@metaset) {
		my $set = $_;
		my($code,@result1) = metastat("-s $set 2>&1");
		@result = (@result,@result1);
	}
	my($code,@result1) = metastat("2>&1");
	if($result1[0] =~ /there are no existing databases/) {
		print "there are no existing databases\n";
	} else {
		Trace "Erreur lors de l'execution du metastat : @result1" if($code != 0);
		@result = (@result,@result1);
		my $ligne_prec = ' ';
		for(@result) {
			my $ligne = $_;
			if($ligne =~ /^\s+(c\dt\dd\ds\d)\s+\d+\s+\S+\s+(\S+)\s+/) {
				ajout($1,$2);
			} elsif($ligne =~ /^\s+State:\s+(.+)$/) {
				my $status = $1;
				my $metadevice = $1 if($ligne_prec =~ /(\S+)\s*$/);
				$metadevice = $1 if($ligne_prec =~ /^(\S+):\s+/);
				ajout($metadevice,$status);
			}
			$ligne_prec = $ligne;
		}
		my $device;
		for(@result) {
			if(/^(\S+): (Mirror|RAID)/) {
				$device = $1;
				$type{$device} = $2;
			} elsif(/^d\d+/) {
				$device = "";
			}
			if($device && $type{$device} eq 'Mirror' && /^\s+Submirror \d+: (\S+)/) {
				push(@{$device{$device}},$1);
			}
			if($device && $type{$device} eq 'RAID' && /^\s+(\S+)\s+\d+\s+\S+\s+\S+/) {
				push(@{$device{$device}},$1);
			}
		}
		foreach $device (sort keys %type) {
			if($type{$device} eq 'RAID') {
				my $ano = "RAID avec seulement " . scalar(@{$device{$device}})
					. " device(s) attache(s)";
				ajout($device,$ano)
					if(@{$device{$device}} && scalar(@{$device{$device}})<3);
			}
			if($type{$device} eq 'Mirror') {
				my $ano = "Mirror avec seulement " . scalar(@{$device{$device}})
					. " device(s) attache(s)";
				ajout($device,$ano)
					if(@{$device{$device}} && scalar(@{$device{$device}})<2);
			}
		}
	}
}

# ---------------------------------------------------------------
# base sur le resultat d'un metastat aprs recherche d'un
# set ventuel.
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	return 0 if(!VerifCommande('METASTAT'));
	TraiteMetadb();
	TraiteMetadevice;
	my $code = %table;
	if($debug) {
		for(keys %table) {
			Trace "table= $_ $table{$_}";
		}
	}
	if($code) {
		$code = 2;
		print "Devices en anomalie :\n\n";
		for(keys %table) {
			print "  $_ $table{$_}\n";
		}
	}
	Trace "code=$code" if($debug);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
