#!/serveur/dp/bin/perl -w

# 	$Id: NFS_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Vrification NFS.
#
# Vrification des processus pour les clients et les serveurs.
# Dtection des montages identiques en plusieurs exemplaires.
#		
# usage : NFS_sur.pl <nom_template>
#
# Codes retour :
#		0 : ok
#		1 : erreur programme
#		2 : alarme ITO
#
# exemple : NFS_sur.pl NFS_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use Fcntl ':flock';
use lib dirname($0);
use dits_def;
require "hostname.pl";

my($host) = split(/\./,hostname());
$host =~ s/^phys-//;
my $log = "/var/tmp/opc_nfs.log";

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# stocke sortie dans fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	print LOG @param;
	print @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# vrification des process ncessaires  NFS
# ---------------------------------------------------------------
sub verif_process {
	my $code = 0;
	my %nb;
	my @process = NFS_process();
	Log "Processus demandes :\n\n";
	for(sort @process) {
		$nb{$_} = 0;
		Log "       daemon|root  $_\n";
	}
	my @result = ps("-ef");
	my $ligne = sprintf("%10s %7s %7s %10s %8s %s\n",
						"UID","PID","PPID","STIME","TIME","CMD");
	Log "\nProcessus actifs :\n\n$ligne";
	for(@result) {
		next if(/^\s*(\S+)\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/<defunct>/);
		next if(/UID/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd) = ($1,$2,$3,$4,$5,$6,$7);
			if($uid =~ /^\s*(daemon|root)\s*$/) {
				my @cmds = split(/\s+/,$cmd);
				map($_ = basename($_), @cmds);
				foreach my $test (@process) {
					if(grep(/^\s*($test)\s*$/,@cmds)) {
						$ligne = sprintf("%10s %7s %7s %10s %8s %s\n",
										 $uid,$pid,$ppid,$stime,$time,$cmd);
						Log $ligne;
						$nb{$test}++;
					}
				}
			}
		} else {
			Log "\nligne non reconnue :\n$_\n";
		}
	}
	Log "\nProcessus non actifs :\n\n";
	foreach my $test (sort @process) {
		if($nb{$test}<1) {
			Log "       daemon|root  $test\n";
			$code = 2;
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# tout est base sur un df -lk (ou bdf -l) qui renvoie :
# Filesystem    Type    kbytes    used   avail capacity  Mounted on
# /dev/dsk/c0t3d0s0 ? 1515942 487265 968040 34% / 
# /proc ? 0 0 0 0% /proc 
# fd ? 0 0 0 0% /dev/fd 
# swap ? 545608 688 544920 1% /tmp 
# ...
# ---------------------------------------------------------------
sub verif_montages {
	Trace "verif_montages" if($debug);
	my %nb;
	my $code = 0;
	return 1 if(! VerifCommande("BDF"));
	Log "\nVrification des montages multiples\n\n";
	my @result = bdf();
	for(@result) {
		next if(/^\s*Filesystem/);
		my($filesystem,$type,$size,$used,$avail,$capacity,$mountpoint) = split(/\s+/);
		if($nb{$filesystem,$mountpoint} && $nb{$filesystem,$mountpoint}==1) {
			Log "  doublon $filesystem sur $mountpoint.\n";
			$code = 2;
		}
		$nb{$filesystem,$mountpoint}++;
	}
	return $code;
}

# ---------------------------------------------------------------
# tout est base sur un df -lk (ou bdf -l) qui renvoie :
# Filesystem    Type    kbytes    used   avail capacity  Mounted on
# /dev/dsk/c0t3d0s0 ? 1515942 487265 968040 34% / 
# /proc ? 0 0 0 0% /proc 
# fd ? 0 0 0 0% /dev/fd 
# swap ? 545608 688 544920 1% /tmp 
# ...
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	unlink $log if(-f $log);
	my %nb;
	my $code = 0;
	$code = 2 if(verif_process()>0);
	$code = 2 if(verif_montages()>0);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
