#!/serveur/dp/bin/perl -w

# 	$Id: MEMO_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Vrification des impressions MEMO.
# Relance de la licence et des impressions si besoin.
#		
# usage : MEMO_sur.pl <nom_template>
#
# Codes retour :
#		0 : ok
#		1 : relance ok (alarme ITO historise)
#		2 : alarme ITO
#
# exemple : MEMO_sur.pl MEMO_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use Fcntl ':flock';
use lib dirname($0);
use dits_def;
require "hostname.pl";

my($host) = split(/\./,hostname());
$host =~ s/^phys-//;
my $log = "/var/tmp/opc_memo.log";
my %nb;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# stocke sortie dans fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	select(LOG); $| = 1;     # autoflush
	select(STDOUT); $| = 1;     # autoflush
	print LOG @param;
	print @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# vrification des process ncessaires  NFS
# ---------------------------------------------------------------
sub verif_process {
	my $code = 0;
	my @result;
	my @process = qw(lpsched eps desksrv ocs_elmd);
	Log "Processus demandes :\n\n";
	for(sort @process) {
		$nb{$_} = 0;
		Log "       root  $_\n";
	}
	@result = ps("-ef");
	my $ligne = sprintf("%10s %7s %7s %10s %8s %s\n",
						"UID","PID","PPID","STIME","TIME","CMD");
	Log "\nProcessus actifs :\n\n$ligne";
	for(@result) {
		next if(/^\s*(\S+)\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/<defunct>/);
		next if(/UID/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd) = ($1,$2,$3,$4,$5,$6,$7);
			if($uid =~ /^\s*(root)\s*$/) {
				my @cmds = split(/\s+/,$cmd);
				map($_ = basename($_), @cmds);
				foreach my $test (@process) {
					if(grep(/^\s*($test)\s*$/,@cmds)) {
						$ligne = sprintf("%10s %7s %7s %10s %8s %s\n",
										 $uid,$pid,$ppid,$stime,$time,$cmd);
						Log $ligne;
						$nb{$test}++;
					}
				}
			}
		} else {
			Log "\nligne non reconnue :\n$_\n";
		}
	}
	Log "\nProcessus non actifs :\n\n";
	foreach my $test (sort @process) {
		if($nb{$test}<1) {
			Log "       root  $test\n";
			$code = 2;
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# appel servOCSEPS status
# ---------------------------------------------------------------
sub verif_status {
	Trace "verif_status" if($debug);
	my %status;
	my ($code,@result) = servOCSEPS('status');
	if($code!=0) {
		Log "servOCSEPS status renvoie un code $code\n\n";
	}
	for(@result) {
		if(/^\s+Status\s+=\s+(\S+)/) {
			$status{$1}++;
		}
	}
	foreach my $status (sort keys %status) {
		if($status{$status}>0 && $status ne 'Up') {
			Log "servOCSEPS status a fait $status{$status} fois Status = $status\'\n\n";
			$code = 2;
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# servOCSEPS ne rend pas la main
# ---------------------------------------------------------------
sub timeout {
	my ($code,@result) = (0);
	eval {
		local $SIG{ALRM} = sub { die "timeout" };
		alarm 30;
		($code,@result) = servOCSEPS('start');
		alarm 0;
	};
	sleep 1;
	return $code;
}

# ---------------------------------------------------------------
# relance licence et impressions
# ---------------------------------------------------------------
sub relance {
	my ($code,$tmp,@result) = (1,0);
	if($nb{ocs_elmd}<1) {
		Log "\nRelance de la licence\n";
		($code,@result) = df("-k /var/tmp");
		my $taux = $1 if($result[1] =~ /\s+(\d+)%\s+/);
		if($taux>90) {
			Log "Relance impossible : /var/tmp est plein a $taux% > 90%\n";
			$code = 2;
		} else {
			($tmp,@result) = servlicenceOCSEPS('start');
			if($tmp!=0) {
				Log "Probleme lors de la relance : @result\n";
				$code = 2;
			} else {
				Log "Relance de la licence ok\n";
			}
		}
	}
	Log "\nArret des impressions\n";
	($tmp,@result) = servOCSEPS('stop');
	if($tmp!=0) {
		Log "Probleme lors de l'arret : @result\n";
		$code = 2;
	} else {
		Log "\nArret des impressions ok\n";
		Log "\nRelance des impressions\n";
		$tmp = timeout();
		if($tmp!=0) {
			Log "Probleme lors de la relance\n";
			$code = 2;
		} else {
			Log "Relance des impressions ok\n";
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# vrifie process et status
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	unlink $log if(-f $log);
	my @result;
	my ($code,$tmp) = (0,0);
	$tmp = verif_process();
	$code = $tmp if($tmp>$code);
	$tmp = verif_status();
	$code = $tmp if($tmp>$code);
	$code = relance() if($code>0);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
