#!/serveur/dp/bin/perl -w

# 	$Id: FLEX_sur.pl,v 2.6 2001/05/21 15:34:34 p004184 Exp $	

# ---------------------------------------------------------------
#
# Surveillance des licences Flex
#
# Recherche de tous les logiciels sous licence Flex
# et vrification via Flex et par ps pour le dmon.
#		
# usage : FLEX_sur.pl nom_template
#
# Code retour :
#		0 : ok, 1 : erreur, 2 : alerte ITO
#
# exemple : FLEX_sur.pl FLEX_sur
#
# ---------------------------------------------------------------

use strict;
use Fcntl ':flock';
use File::Basename;
use lib dirname($0);
use dits_def;
require "hostname.pl";
use Time::Local;
use AnyDBM_File;
use Fcntl;
use Time::Local;

my $log = "/var/tmp/opc_flex.log";

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my %mois = ('jan',1,'feb',2,'mar',3,'apr',4,'may',5,'jun',6,
			'jul',7,'aug',8,'sep',9,'oct',10,'nov',11,'dec',12);

# ---------------------------------------------------------------
# features pas  jour : pas d'alerte dessus
# ---------------------------------------------------------------
my $licences_naze = 'metrolog-test|maple';

my @pas_a_jour = (
# icem
				  'TETRA','PRISM',
# deneb
				  'DWG_DRW_BATCH:18779',
				  'DWG_PDB_BATCH:18779',
				  'UG:18779',
				  'SDRC_BATCH:18779',
				  'IGES_BATCH:18779',
				  'CATDIR:18779',
				  'PRO_BATCH:18779',
				  'IGRIP:18779',

				  );

my @temp;
while(@pas_a_jour) {
	push(@temp,quotemeta shift(@pas_a_jour));
}
my $pas_a_jour = join('|',@temp);
my $licences;
my $host = hostname();
my %port;

my $port_pas_a_jour = "1973";

# table des *alias* pour la map services
my %petit_nom = ('ideasms4','ims4',
				 'ideasms5','ims5',
				 'ideasms6','ims6',
				 'pvwave','pwav');

Trace "lecture services" if($debug);
my @services = ypcat("services");
Trace "lecture sockets" if($debug);
my @sockets = netstat("-a");
my @local_services;
my @message;
my %nom_court;

# -------------------------------------------------------------------
# calcul de l'heure courante
# -------------------------------------------------------------------
my($jour_cour,$mois_cour,$annee_cour,$heure_cour,$min_cour,$sec_cour) =
	split(/:/,date("%d:%m:%Y:%H:%M:%S"));
my $time_courant = timelocal($sec_cour,$min_cour,$heure_cour,
							 $jour_cour,$mois_cour-1,$annee_cour);

# -------------------------------------------------------------------
# Parcours de la base DB
# On utilise un fichier lock pour viter les problmes...
# On veut 3 jours (72h) sparant 2 messages
# -------------------------------------------------------------------
sub filtre_feature {
	my($version,$licence,$feature) = @_;
	my $dir = OpcLog();
	my $base = "$dir/filtre_flex.db";
	my $lock = "$dir/filtre_flex.lock";
	my %date;
	my $code = 1;
	my $nb_heure = 72;
	open(LOCK,">>$lock") && flock(LOCK,LOCK_EX)
		&& tie(%date,'NDBM_File',$base,O_RDWR|O_CREAT, 0640);
	if(!$date{"$version$licence$feature"}
	   || $time_courant<$date{"$version$licence$feature"}
	   || (($time_courant-$date{"$version$licence$feature"})/(60*60))>$nb_heure) {
		$code = 0;
		$date{"$version$licence$feature"} = $time_courant;
	}
	untie(%date);
	flock(LOCK,LOCK_UN);
	close(LOCK);
	return $code;
}

# ---------------------------------------------------------------
# stocke sortie dans fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	print LOG @param;
	print @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# startup<version> : permet de relancer 1 serveur
#		- attendre que les sockets soient fermes (netstat) sur les
#		  serveurs  relancer
# ---------------------------------------------------------------
sub RelanceLicence {
	my ($dir,$version,$licence) = @_;
	my @licence;
	my $stat = "$dir/stat_$version";
	my $shutdown = "shutdown_$version";
	my $startup = "startup_$version";
	my $reread = "reread_$version";
	my @result = `$stat list`;
	for(@result) {
		next if(/Liste des logiciels sous license/);
		next if(/^alias/);
		chomp(my $licence = $_);
		@licence = (@licence,$licence);
	}
	foreach my $licence (@licence) {
		TraiteLicence($licence);
	}
}

# ---------------------------------------------------------------
# Vrification du dmon par un ps
# ---------------------------------------------------------------
sub VerifDemon {
	my($daemon) = @_;
	my $code = 2;
	my @result = ps("-ef");
	for(@result) {
		next if(/^\s*(\S+)\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/UID/);
		next if(/defunct/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd)=($1,$2,$3,$4,$5,$6,$7);
			if($uid =~ /^\s*root\s*$/) {
				my @cmds = split(/\s+/,$cmd);
				map($_ = basename($_), @cmds);
				$code = 0 if(grep(/^\s*$daemon\s*$/,@cmds)>0);
			}
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# Concatne une array pour former une chane de test
# ---------------------------------------------------------------
sub forme_test {
	my @array = @_;
	my $test;
	for(@array) {
		my $elem = quotemeta($_);
		if($test) {
			$test = "$test|$elem";
		} else {
			$test = "$elem";
		}
	}
	return $test;
}

# ---------------------------------------------------------------
# Vrification des sockets
# ---------------------------------------------------------------
sub VerifSockets {
	my($port,$service) = @_;
	my $code = 0;
	my ($active,$fermee) = (0,0);
	my %nb_status;
	my @socket = grep(/\.($port|$service)\s+/,@sockets);
	for(@socket) {
		my $state = $1 if(/\s+(\S+)\s*$/);
		next if($state eq '*.*');
		$nb_status{$state}++;
		if($state =~ /IDLE|CLOSED|CLOSE_WAIT|FIN_WAIT_1|CLOSING|LAST_ACK|FIN_WAIT_2|TIME_WAIT/) {
			$fermee++;
		} elsif($state =~ /LISTEN|SYN_SENT|SYN_RECEIVED|SYN_RCVD|ESTABLISHED/) {
			$active++;
		} elsif($state !~ /BOUND/) {
			push(@message,"    status socket inconnu : $state\n");
			$code = 2;
		}
	}
	if($active==0) {
		push(@message,"    Pas de socket active ($port,$service)\n");
		$code = 2;
	}
	for(sort keys %nb_status) {
		push(@message,"    $nb_status{$_} socket(s) $_\n");
	}
	return $code;
}

# ---------------------------------------------------------------
# Vrification des ports :
# - 1 seul et mme port pour tous les serveurs d'une licence
# - 1 port unique par licence
# - port renseign dans la map services avec un nom explicite (nom ou
#   dbut du nom de la licence, nom ou dbut du nom du dmon,
#   abbrviation connue)
# - les sockets sont limites  un nom de 8 caractres, on vrifie
#   donc les doublons sur les 8 premiers caractres du nom de service
# - 1 ligne unique par port dans la map services et en tcp
# - 1 ligne unique par service dans la map services
# ---------------------------------------------------------------
sub VerifPorts {
	my ($version,$licence,$daemon) = @_;
	my $code = 0;
	my @ports = FlexPorts($version,$licence);
	my $i;
	if(! @ports) {
		push(@message,"    Pas de port serveur dans le parametrage\n");
		return 2;
	}
	for($i=1;$i<@ports;$i++) {
		if($ports[$i]!=$ports[$i-1]) {
			push(@message,"    Plusieurs ports serveur differents dans le parametrage\n");
			$code = 2;
		}
	}
	my $port = $ports[0];
	return 0 if($port =~ /^($port_pas_a_jour)$/);
	if($port{$port} && $port{$port} ne "$licence ($version)") {
		push(@message,"    Port serveur $port deja attribue a $port{$port}\n");
		$code = 2;
	}
	my @service = grep(/^\S+\s+$port\/tcp/,@services);
	if(@service>1) {
		push(@message,"    Doublons dans la map services pour le port $port\n");
		for(@service) {
			my($nomserv,$portserv,@commentserv) = split;
			push(@message,"    --> $nomserv   $portserv   @commentserv\n");
		}
		$code = 2;
	} elsif(@service==0) {
		push(@message,"    Port $port non trouve dans la map services\n");
		$code = 2;
	} elsif($service[0] =~ /^(\S+)\s+/) {
		my $nom = $1;
		my $fin = $nom;
		$fin =~ s/^FLEX//;
		$fin =~ s/^FX//;
		if($nom !~ /$licence|$daemon/
		   && ($petit_nom{$licence} && $nom !~ /$petit_nom{$licence}/)
		   && $licence !~ /^$fin/
		   && $daemon !~ /^$fin/) {
			push(@message,"    Nom de service $nom associe au port $port pas assez explicite\n");
			$code = 2;
		}
		my $nom_court = substr($nom,0,8);
		if($nom_court{$nom_court}) {
			push(@message,"    Nom court $nom_court en double avec $nom_court{$nom_court}\n");
			$code = 2;
		} else {
			$nom_court{$nom_court} = $licence;
		}
		@service = grep(/^$nom\s+\d+\/tcp/,@services);
		if(@service>1) {
			push(@message,"    Doublons dans la map services pour le service $nom\n");
			for(@service) {
				my($nomserv,$portserv,@commentserv) = split;
				push(@message,"    --> $nomserv   $portserv   @commentserv\n");
			}
			$code = 2;
		}
		@service = grep(/^$nom\s+\d+\/tcp/,@local_services);
		if(@service>1) {
			push(@message,"    Doublons dans /etc/services pour le service $nom\n");
			for(@service) {
				my($nomserv,$portserv,@commentserv) = split;
				push(@message,"    --> $nomserv   $portserv   @commentserv\n");
			}
			$code = 2;
		} elsif(@service==1 && $service[0] =~ /^\S+\s+(\d+)\/tcp/) {
			my $port_local = $1;
			if($port_local != $port) {
				push(@message,"    Le service $nom est sur le port $port dans la map services\n");
				push(@message,"        mais sur $port_local dans /etc/services\n");
				$code = 2;
			}
		}
		@service = grep(/^\S+\s+$port\/tcp/,@local_services);
		if(@service>1) {
			push(@message,"    Doublons dans /etc/services pour le port $port\n");
			for(@service) {
				my($nomserv,$portserv,@commentserv) = split;
				push(@message,"    --> $nomserv   $portserv   @commentserv\n");
			}
			$code = 2;
		} elsif(@service==1 && $service[0] =~ /^(\S+)\s+/) {
			my $nom_local = $1;
			if($nom_local ne $nom) {
				push(@message,"    Port $port associe au service $nom dans la map services\n");
				push(@message,"        mais au service $nom_local dans /etc/services\n");
				$code = 2;
			}
		}
		$code = 2 if(VerifSockets($port,$nom_court)>0);
	}
	$port{$port} = "$licence ($version)";
	return $code;
}

# ---------------------------------------------------------------
# stat_<version> <nom licence> -> statut de la licence
# des 3 serveurs associs et des dmons.
# On ne vrifie la prsence du process de la licence que sur
# les 3 serveurs paramtrs dans Flex.
# Mieux, on ne renvoie une erreur que sur ces 3 serveurs.
# ---------------------------------------------------------------
sub TraiteLicence {
	my ($version,$licence) = @_;
	Trace "TraiteLicence $version,$licence" if($debug);
	my $master;
	my $nb_master = 0;
	my @licence;
	my $code = 0;
	my ($status_daemon,$status_server) = (0,0);
	my($i,$j);
	my(%date,%nombre,@features,%date_clair,%daemon);
	my($jour_cour,$mois_cour,$annee_cour,$heure_cour,$min_cour,$sec_cour) =
		split(/:/,date("%d:%m:%Y:%H:%M:%S"));
	my $time_cour = timelocal($sec_cour,$min_cour,$heure_cour,
							  $jour_cour,$mois_cour-1,$annee_cour);
	my $prochaine_expiration = $time_cour + 7*24*60*60;
	my @serveurs = FlexServers($version,$licence);
	my $test_serveurs = forme_test(@serveurs);
	my $serveurs = join(' ',@serveurs);
	return 0 if($serveurs && $serveurs !~ /$host/);
	my ($daemon,$path_daemon) = FlexDaemon($version,$licence);
	my @temp = FlexFeatures($version,$licence);
	for(@temp) {
		my @test = $_;
		my ($feature,$date,$nombre,$fdaemon) = ($test[0][0],$test[0][1],$test[0][2],$test[0][3]);
		push(@features,$feature);
		$daemon{$feature} = $fdaemon;
		$date_clair{$feature} = $date;
		if($date eq 'permanent') {
			$date{$feature} = $prochaine_expiration+1;
		} else {
			my($jour,$mois,$annee) = split(/-/,$date);
			if($annee==0) { # licence permanente
				$date{$feature} = $prochaine_expiration+1;
			} else {
				$mois =~ tr/A-Z/a-z/;
				$mois = $mois{$mois};
				$mois--;
				$annee += 2000 if($annee<40);
				$annee += 1900 if($annee<1900);
				$date{$feature} = timelocal(0,0,0,$jour,$mois,$annee)
					if(!$date{$feature} || timelocal(0,0,0,$jour,$mois,$annee)>$date{$feature});
			}
		}
		$nombre = 0 if($nombre eq 'uncounted');
		$nombre{$feature} = $nombre if(!$nombre{$feature} || $nombre>$nombre{$feature});
	}
	my $test_features = forme_test(@features);
	my $features = join(' ',@features);
	my($serveur,@status);
	@message = ("\nLicence $licence (Flex $version");
	push(@message,", serveurs: $serveurs") if($serveurs);
	push(@message,", demon: $daemon") if($daemon);
	push(@message,")\n\n");
	if(! @serveurs) {
		push(@message,"    Pas de serveur dans le parametrage\n");
		$code = 2;
	}
	if(! $daemon) {
		push(@message,"    Pas de demon dans le parametrage\n");
		$code = 2;
	}
	if(! $path_daemon) {
		push(@message,"    Pas de repertoire pour le demon dans le parametrage\n");
		$code = 2;
	}
	if($path_daemon && ! -d "$path_daemon" && ! -f "$path_daemon") {
		push(@message,"    Repertoire $path_daemon non trouve\n");
		$code = 2;
	}
	if($path_daemon && ! -f "$path_daemon" && $daemon && ! -f "$path_daemon/$daemon") {
		push(@message,"    Demon $path_daemon/$daemon (ou $path_daemon) non trouve\n");
		$code = 2;
	}
	if($features =~ /^\s*$/) {	# ce n'est pas forcment une anomalie
		push(@message,"    Pas de feature dans le parametrage\n");
	}
	$code = 2 if(VerifPorts($version,$licence,$daemon));
	Trace "FlexStat $version,$licence" if($debug);
	my @result = FlexStat($version,$licence);
	for(@result) {
		next if(/^$/);
		my $ligne = $_;
		if($ligne =~ /lmgrd is not running: (.*)$/) {
			push(@message,"    lmgrd : $1\n");
			$code = 2;
		}
		if($daemon && $ligne =~ /^\s+$daemon(|\s+\S+):\s+(.*)$/) {
			my $status = $2;
			$status_daemon = 1;
			if(! $status || $status !~ /UP/) {
				push(@message,"    $daemon : $status\n");
				$code = 2;
			} elsif(VerifDemon($daemon)>0) {
				push(@message,"    Process $daemon absent (Flex indique un status UP)\n");
				$code = 2;
			}
		} elsif($serveurs !~ /^\s*$/ && $ligne =~ /^\s*($test_serveurs):\s+(.*)$/) {
			my ($serveur,$status) = ($1,$2);
			$status_server = 1;
			if(! $status || $status !~ /license server UP/) {
				push(@message,"    $ligne");
				$code = 2 if($host eq $serveur); # alerte slt sur le serveur en erreur
			}
			 if($status && $status =~ /MASTER/) {
				 $master = $serveur if(!$master);		# on prend slt le premier master
				 $nb_master++;
			 }
		} elsif($features !~ /^\s*$/ && $ligne =~ /^Users of ($test_features):\s+(.*)$/) {
			my ($feature,$status) = ($1,$2);
			next if($daemon{$feature} eq 'none' && $nombre{$feature}==0); # locales
			next if($master && $host ne $master); # alerte slt sur le serveur master
			if($feature =~ /^($pas_a_jour)$/) {
				push(@message,"    licence $feature pas a jour et non verifiee\n");
				next;
			}
			if($date{$feature}<$time_cour) {
				my $texte = "licence $feature expiree";
				push(@message,"    $texte\n");
				if(! filtre_feature($version,$licence,$feature)) {
					opcmsg("Flex",$licence,$texte,"major","licences");
				}
			} else {
				if($date{$feature}<$prochaine_expiration) {
					my $texte = "la licence $feature expire le $date_clair{$feature}";
					push(@message,"    $texte\n");
					if(! filtre_feature($version,$licence,$feature)) {
						opcmsg("Flex",$licence,$texte,"minor","licences");
					}
				}
				if(($nombre{$feature}>0
					&& (! $status || $status !~ /Total of \d+ license(|s) available/))
				   || ($nombre{$feature}==0
					   && $status && $status !~ /^\s*$|[uU]ncounted, node-locked/)) {
					push(@message,"    $ligne");
					$code = 2;
				} elsif($nombre{$feature}>0 && $status
						&& $status !~ /Total of (\d+) license(|s) available/) {
					my $nbf = $1;
					if($nbf != $nombre{$feature}) {
						push(@message,"    $feature a $nbf jetons au lieu de $nombre{$feature}\n");
						$code = 2;
					}
				}
			}
		}
	}
	if(!$status_daemon) {
		push(@message,"    Status du daemon non trouve\n");
		$code = 2;
	}
	if(!$status_server) {
		push(@message,"    Status des serveurs non trouves\n");
		$code = 2;
	}
	if($nb_master>1) {
		push(@message,"    $nb_master serveurs MASTER\n");
		$code = 2;
	}
	if($code>0) {
		Log(@message);
		if($licences) {
			$licences = "$licences,$licence";
		} else {
			$licences = $licence;
		}
	}
# 	$code = RelanceLicence($version,$licence) if($code>0);
	return $code;
}

# ---------------------------------------------------------------
# stat_<version> list -> liste des licences
# $code2==3 si la version n'est pas installe
# On ne traite pas les stat_<version> ne renvoyant pas la bonne version
# ---------------------------------------------------------------
sub TraiteVersion {
	my ($version) = @_;
	Trace "TraiteVersion $version" if($debug);
	my $code = 0;
	my @result = FlexStat($version,"list");
	if($result[0] =~ /version $version non trouvee|non disponible sous license Flex/) {
		Log("\nFlex n'est pas install pour la version $version\n\n");
		if($licences) {
			$licences = "$licences,v$version";
		} else {
			$licences = "v$version";
		}
#		$code = 3;
	} else {
		for(@result) {
			if(/Liste des logiciels sous license Flex (\S+)/) {
				my $version_reelle = $1;
				if($version_reelle ne $version) {
					Log("\nScript ou licence existant pour une version $version inconnue\n");
					$code = 2;
					last;
				}
				next;
			}
			chomp(my $licence = $_);
			next if($licence =~ /^alias|^($licences_naze)$/);
			my $code2 = TraiteLicence($version,$licence);
			$code = $code2 if($code2>$code);
			last if($code2==3);
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# la config des licences Flex est dans /serveur/Flex (ou /home/...)
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	unlink $log if(-f $log);
	my $code = 0;
	if(FlexServeur()) {
		Trace "lecture /etc/services" if($debug);
		if(open(SERVICES,"/etc/services")) {
			@local_services = grep(!/^\#/,<SERVICES>);
			close(SERVICES);
		} else {
			@local_services = ("fichier non trouve");
		}
		my @version = FlexVersion();
		for(@version) {
			my $version = $_;
			my $code2 = TraiteVersion($version);
			$code = $code2 if($code2>$code);
		}
		if(!$licences) {
			$licences = "aucune";
			Log("\nToutes les licences sont ok\n\n");
		}
	} else {
		$licences = "aucune";
		Log("\nCette machine n'est pas serveur de licences Flex\n\n");
		opcmsg("Parametrage","FLEX_sur","Cette machine n'est pas serveur Flex","minor","OpC");
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : liste des doublons user/processus
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "param=@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($NomTemplate && $debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO -option licences=$licences");
	exit 0;
}

__END__
