#!/serveur/dp/bin/perl -w

# 	$Id: DSK_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Vrification de l'espace disque pour les volumes systme
# (autres que GDG).
#
# Les alertes sont envoyes  Filtre.pl qui temporise les
# alertes. Pour les disques on ne cre des alertes que tous
# les 3 jours (avec des exceptions selon le filesystem).
#		
# Des points de montage sont non surveills mme s'ils correspondent 
# d'autres conditions :
# - /proc, /dev/fd, /tmp
# - /libre
# - /clapton/data, /vorlon/data : bases Oracle
#
# Tables des pourcentages max et espace min (en Mo)  vrifier
#	- Si un mountpoint correspond  plusieurs conditions, toutes les
#	conditions seront vrifies mais une seule alerte sera remonte.
#	- Si un mountpoint est indiqu pour un pourcentage et un espace
#	minimum, il faut que les 2 conditions soient vrifies :
#	si on a '/','80%' et '/','10000K', il n'y aura une alerte
#	que si / contient moins de 10000Ko et est rempli  plus de 80%.
# Seuils de remplissage en pourcentage
# '.*/arch'				80
# '.*/disk.*'			99
# '.*/export.*'			95
# '/$host'				95
# '/'					80
# '/var'				80
# Seuils d'espace disponible en Mo
# '.*/data.*'			200
# '.*/export.*'			50
# '.*/implan.*'			200
# '.*logiciel.*'		50
# '.*soft.*'			50
# '/$host'				200
# '/'					20
# '/var'				10
#
# L'implantation a un fichier nomm IMPLANTATION dans le rpertoire
# des disques qui ne sont plus utiliss (donc on les prend comme
# des disques normaux) et IMPLANTATION_ACTIF pour le disque actuellement
# utilis. Le seuil des disques implantation actifs est  400Mo.
#
# usage : DSK_sur.pl <nom_template>
#
# Codes retour :
#		0 : ok
#		1 : erreur programme
#		2 : alarme ITO
#
# exemple : DSK_sur.pl DSK_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;
require "hostname.pl";

my($host) = split(/\./,hostname());
$host =~ s/^phys-//;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();
my $appel_filtre = 1;

# ---------------------------------------------------------------
# Points de montage non surveills
# ---------------------------------------------------------------
my $non_surveille = '^\/tmp$|^\/proc$|^/dev/fd$|\/libre|\/clapton\/data|\/vorlon\/data';

# ---------------------------------------------------------------
# Tables des pourcentages max et espace min (en Mo)  vrifier
#	On peut utiliser les caractres gnriques ( la mode perl)
#	pour dcrire les mountpoint.
# ---------------------------------------------------------------
my(%POURCENT) = ('.*/arch',80,
				 '.*/disk.*',99,
				 '.*/export.*',95,
				 '/$host',95,
				 '/',80,
				 '/var',80);

my(%MIN) = ('.*/data.*',200,
			'.*/export.*',50,
			'.*/implan.*',200,
			'.*logiciel.*',50,
			'.*soft.*',50,
			'/$host',200,
			'/',20,
			'/var',10);


# ---------------------------------------------------------------
# dtermine le type du disque
# ---------------------------------------------------------------
sub type {
	my $mountpoint = shift(@_);
	my $type = 'normal';
	if($mountpoint =~ /(data|implan)\d+$/) {
		if(opendir(DIR,$mountpoint)) {
			my @dir = readdir(DIR);
			close(DIR);
			$type = 'implantation' if(grep(/IMPLANTATION_ACTIF/,@dir));
		}
	}
	return $type;
}

# ---------------------------------------------------------------
# ajuste les valeurs en fonction du type
# ---------------------------------------------------------------
sub ajuste {
	my ($val,$type) = @_;
	my ($pourcent,$min) = ($POURCENT{$val},$MIN{$val});

	$min = 400 if($min<400 && $type eq 'implantation');

	$min = $min * 1024;
	return ($pourcent,$min);
}

# ---------------------------------------------------------------
# tout est base sur un df -lk (ou bdf -l) qui renvoie :
# Filesystem    Type    kbytes    used   avail capacity  Mounted on
# /dev/dsk/c0t3d0s0 ? 1515942 487265 968040 34% / 
# /proc ? 0 0 0 0% /proc 
# fd ? 0 0 0 0% /dev/fd 
# swap ? 545608 688 544920 1% /tmp 
# ...
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	my $domaine = domainname();
	return 0 if($domaine =~ /^(vsf|ica)$/);
	return 1 if(! VerifCommande("BDF"));
	my $dir = dirname($0);
	my @result = bdf();
	for(keys %POURCENT) {
		$MIN{$_} = 0 if(!$MIN{$_});
	}
	for(keys %MIN) {
		$POURCENT{$_} = 100 if(!$POURCENT{$_});
	}
	for(@result) {
		my($filesystem,$type,$size,$used,$avail,$capacity,$mountpoint) = split(/\s+/);
		if(/^\s*Filesystem/) {
			print "Les filesystem suivant n'ont pas l'espace disponible requis.\n\n";
			printf("%28s %10s %10s %10s %5s %s\n",' ',$size,$used,$avail,$capacity,$mountpoint);
		} else {
			next if($mountpoint =~ /$non_surveille/);		# non surveills
			next if($filesystem !~ /^\/dev/);				# montage NFS
			my $type = type($mountpoint);
			for(keys %POURCENT) {
				my $val = $_;
				my($pourcent,$min) = ajuste($val,$type);
				if($mountpoint =~ /^$val$/) {
					$capacity =~ s/%//;
					if(($pourcent==100 || $capacity > $pourcent)
					   && ($min==0 || $avail < $min)) {
						printf("%3d%% max %10dK min >>> %10d %10d %10d %4d%% %s\n",
							   $pourcent,$min,
							   $size,$used,$avail,$capacity,$mountpoint);
						if($appel_filtre) {
							my @result = `$dir/Filtre.pl 1 $mountpoint`;
							if($?>0) {
								$code = 1;
								print "erreur $dir/Filtre.pl 1 $mountpoint\n";
								print @result;
							}
						}
						last;
					}
				}
			}
		}
	}
	print "\n";
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);
if(!$NomTemplate || $NomTemplate eq "bidon") {
	$appel_filtre = 0;
}

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
