#!/serveur/dp/bin/perl -w


# -------------------------------------------------------------------
# Liste une base de filtrage des alertes.
#
# usage : scan_filtre.pl <type de filtre>
#
#		type de filtre : 1=filesystem
#
# Code retour :
#		0 : ok , sinon : erreur
#
# exemples :
#		Filtre.pl 1
#		Filtre.pl 2
#
# -------------------------------------------------------------------

use strict;
use AnyDBM_File;
require "ctime.pl";
use File::Basename;
use lib dirname($0);
use dits_def;

# -------------------------------------------------------------------
# Rcupration des paramtres : type de la base  lister
# -------------------------------------------------------------------
my $type_filtre = shift(@ARGV);

# -------------------------------------------------------------------
# Parcours de la base DB
# -------------------------------------------------------------------
sub liste_db {
	my($nom) = @_;
	my $dir = OpcLog();
	my $base = "$dir/filtre_${nom}.db";
	my %date;

	tie(%date,'NDBM_File',$base,1,0);
	for(sort keys %date) {
		chomp(my $date = ctime($date{$_}));
		print "$date $_\n";
	}
	untie(%date);
}

# -------------------------------------------------------------------
# Appel fonctions selon le type de filtre
# -------------------------------------------------------------------
my $code = 0;

if(! $type_filtre) {
	print "Parametre type de filtre requis\n";
	$code = 1;
} elsif($type_filtre !~ /^\d+$/) {
	print "Parametre type de filtre ($type_filtre) non numerique\n";
	$code = 1;
} elsif($type_filtre == 1) {						# filesystem
	liste_db("dsk");
} elsif($type_filtre == 3) {						# licences flex
	liste_db("flex");
} else {
	print "Type de filtre ($type_filtre) non encore traite\n";
	$code = 1;
}

exit $code;

__END__
