#!/serveur/dp/bin/perl -w

# 	$Id: inst_cron.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# -------------------------------------------------------------------
# Modification, ajout ou suppression de lignes pour l'installation
# du contrle ITO en crontab
# -------------------------------------------------------------------

use strict;
use Fcntl ':flock';
require "hostname.pl";
use File::Basename;
use lib dirname($0);
use dits_def;

my $host = hostname();

# ------------------------------------------------------------------
# Dans @ancien, mettre la ou les lignes  modifier. Dans @nouveau
# mettre la ou les lignes qui vont remplacer les anciennes.
# Pour une ligne  ajouter, la mettre aussi dans @ancien ce qui vite
# les doublons.
# Pour une ligne  supprimer, la mettre en commentaire dans @nouveau.
# ------------------------------------------------------------------
my @ancien;
my @nouveau;

sub maj_crontab {
	my ($ajout) = @_;
	my $ok = 0;
	my @actuel = `crontab -l`;
	my $code = $?;
	if($code == 0) {
		my $ancien = join("\n",@ancien);
		my $nouveau = join("\n",@nouveau);
		my $test_ancien = quotemeta $ancien;
		my $test_nouveau = quotemeta $nouveau;
		my $actuel = join('',@actuel);
		if($actuel =~ /$test_nouveau/) {
			print "crontab deja a jour\n";
		} elsif($actuel =~ /$test_ancien/) {
			$actuel =~ s/$test_ancien/$nouveau/;
			print "anciennes lignes modifiees\n";
			$ok = 1;
		} elsif($ajout) {
			$actuel = "$actuel\n$nouveau\n";
			print "lignes ajoutees\n";
			$ok = 1;
		}
		if($ok) {
			if(open(CRON,"|crontab")) {
				print CRON $actuel;
				close(CRON);
			} else {
				print "open crontab : $!\n";
			}
		}
	} else {
		print "crontab -l : $!\n";
	}
}

system("crontab -l > /tmp/cron.tab.orig");

print "logchecker... ";
@ancien = ("0 2 * * 0,4 /etc/cron.d/logchecker");
@nouveau = ("# rotation fichier log de cron",
			   "0 2 * * * /etc/cron.d/logchecker");
maj_crontab(0);

print "rtc... ";
@ancien = ("1 2 * * * [ -x /usr/sbin/rtc ] && /usr/sbin/rtc -c > /dev/null 2>&1");
@nouveau = ("1 2 * * * if [ -x /usr/sbin/rtc ] ; then /usr/sbin/rtc -c > /dev/null 2>&1 ; fi");
maj_crontab(0);

print "controle ITO... ";
@ancien = ("#",
		   "# controle ITO hors heures de sauvegarde du serveur",
		   "#",
		   "0,10,20,30,40,50 4-23 * * * /var/opt/OV/bin/OpC/cmds/launch_perl OPC_ctl.pl");
@nouveau = ("#",
			"# controle ITO hors heures de sauvegarde du serveur",
			"#",
			"0,10,20,30,40,50 5-22 * * * /var/opt/OV/bin/OpC/cmds/OPC_ctl.pl");
maj_crontab(1);

print "-----------------------------\n";
print "diff de la crontab\n";
print "-----------------------------\n";
system("crontab -l > /tmp/cron.tab");
print `diff /tmp/cron.tab.orig /tmp/cron.tab`;


__END__
