#!/serveur/dp/bin/perl -w

# 	$Id: OPC_ctl.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance et relance de l'agent ITO
#
#		Ce script est destin  tre lanc par cron
#		toutes les 10mn afin de relancer l'agent ITO
#		si besoin est.
#		Un arrt forc est programm toutes les nuits
#		 minuit.
#		
# usage : /var/opt/OV/bin/OpC/cmds/OPC_ctl.pl
#
#		Le rpertoire peut varier selon l'OS.
#
# Code retour :
#		0 : ok, 1 : problme
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;
use opc;
require "hostname.pl";

my $debug = Debug();
my $host = hostname();
my $mail_addr = 'Michel Verdier <verdiemi@tavern.ctr.renault.fr>';
my $date = date("%H%M");
my $lock = "/var/tmp/opc_ctl.lock";
my $opclog = OpcLog();

# ---------------------------------------------------------------
# processus ITO  surveiller avec le user associ
# ---------------------------------------------------------------
my %user = ("opcctla","root",
			"opcmsgi","root",
			"opcmsga","root",
			"llbd","root",
			"dced","root");

my %srv = ("opcctlm","root",
		   "opcactm","root",
		   "opcmsgm","root",
		   "opcttnsm","root",
		   "opcforwm","root",
#		   "opcuiwww","root",
		   "opcdispm","root",
		   "opcdistm","root",
		   "oracle$host","daemon",
		   "ora_smon_$host","oracle",
		   "ora_ckpt_$host","oracle",
		   "ora_reco_$host","oracle",
		   "ora_lgwr_$host","oracle",
		   "ora_dbwr_$host","oracle",
		   "ora_pmon_$host","oracle",
		   "ora_s000_$host","oracle",
		   "ora_d000_$host","oracle",
		   "tnslsnr","daemon");

my @fichiers_obligatoires = ('agtreg',
							 'le',
							 'mgrconf',
							 'monitor',
							 'msgi',
							 'nodeinfo',
							 'opcnetls');

sub nettoyage {
}

# ---------------------------------------------------------------
# relance llbd
# attention : netls utilise ncs, vrifier les sockets
# ---------------------------------------------------------------
sub relance_llbd {
	my $code = 0;
	return 0;
	my @result;
	if(VerifCommande('NCS')) {
		($code,@result) = ncs("stop");
		($code,@result) = ncs("start");
		if($code == 0) {
			Trace "relance automatique llbd ok" if($debug);
		} else {
			Trace "relance automatique llbd : @result" if($debug);
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# vrification des agents et sous-agents
# ---------------------------------------------------------------
sub opcctla_hs {
	my($code,@result) = opcctla("-status");
	for(@result) {
		$code = 1 if(/OpC30-|isn\'t running$/);
		$code = 1 if(/not running/);
	}
	Trace "opcctla : status errone\n@result" if($debug && $code==1);
	return $code;
}

# ---------------------------------------------------------------
# vrification des fichiers temporaires
# ---------------------------------------------------------------
sub VerifTmp {
	my $code = 0;
	my $tmp = OpcTmp();
	my $max_moa = 100;
	my $max_size = 200;
	if(-d "$opclog/mgmt_sv") {
		$max_moa = 200;
		$max_size = 500;
	}
	if($tmp && opendir(TMP,$tmp)) {
		my @dir = readdir(TMP);
		closedir(TMP);
		if(grep(/^moa/,@dir)>$max_moa) {
			Trace "Plus de $max_moa messages en buffer" if($debug);
			$code = 1;
		}
		for(@dir) {
			if(/q$/) {
				my $file = $_;
				my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
				   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat("$tmp/$file");
				if($st_size>$max_size*1024) {
					Trace "$file : taille suprieure  ${max_size}Ko" if($debug);
					$code = 1;
				}
			}
		}
	} else {
		Trace "opendir $tmp : $!\n" if($debug);
		$code = 1;
	}
	return $code;
}

# ---------------------------------------------------------------
# vrification des managers
# ---------------------------------------------------------------
sub opcctlm_hs {
	Trace "opcctlm_hs" if($debug);
	my($code,@result) = opcctlm("-status");
	for(@result) {
		$code = 1 if(/OpC40-|isn\'t running$/ && !/opcuiwww/);
		$code = 1 if(/not running/);
	}
	if(grep(/running/,@result)==0) { # erreur grave sur le serveur
		Trace "opcctlm : @result";
		exit 1;
	}
	Trace "opcctlm : status errone\n@result" if($debug && $code==1);
	($code,@result) = ovstatus();
	for(@result) {
		$code = 1 if(/^state:\s+/ && ! /^state:\s+RUNNING/);
	}
	Trace "ovstatus : status errone\n@result" if($debug && $code==1);
	return $code;
}

# ---------------------------------------------------------------
# tout est base sur un ps qui renvoie $uid,$pid,$ppid,$cmd
# ---------------------------------------------------------------
sub Traitement_serveur {
	my($passage) = @_;
	Trace "Traitement serveur" if($debug);
	my $code = 0;
	my %nb;
	for(keys %srv) {
		$nb{$_} = 0;
	}
	my @result = ps("-ef");
	for(@result) {
		next if(/\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/UID/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd)=($1,$2,$3,$4,$5,$6,$7);
			my @cmds = split(/\s+/,$cmd);
			map($_ = basename($_), @cmds);
			foreach my $test (sort keys %srv) {
				if($uid =~ /^\s*($srv{$test})\s*$/) {
					$nb{$test}++ if(grep(/^\s*($test)\s*$/,@cmds)>0);
				}
			}
		}
	}
	my $manque = 0;
	for(keys %srv) {
		$manque = 1 if($nb{$_} == 0);
		Trace "il manque $_" if($debug && $nb{$_} == 0);
	}
	if($manque || opcctlm_hs()) {
		if($passage && $passage>1) {
			arret_ito(3);
			$code = demarrage_ito(3);
		} else {
			arret_ito(0);
			demarrage_ito(3);
			$code = Traitement_serveur(2);
		}
		Trace "relance serveur code=$code" if($debug);
	} else {
		Trace "Tout est ok" if($debug);
	}
	return $code;
}

# ---------------------------------------------------------------
# presque tout est base sur un ps qui renvoie $uid,$pid,$ppid,$cmd
# ---------------------------------------------------------------
sub Traitement_noeud {
	Trace "Traitement noeud" if($debug);
	my $code = 0;
	my %nb;
	for(keys %user) {
		$nb{$_} = 0;
	}
	nettoie_log();
	opcmsg("Control","debug","Mode debug sur cette machine","warning","OpC") if($debug);
	my @result = ps("-ef");
	return 0 if(grep(/opcctla -config/,@result)>0); # install en cours
	for(@result) {
		next if(/\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/UID/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd)=($1,$2,$3,$4,$5,$6,$7);
			my @cmds = split(/\s+/,$cmd);
			map($_ = basename($_), @cmds);
			foreach my $test (sort keys %user) {
				if($uid =~ /^\s*($user{$test})\s*$/) {
					$nb{$test}++ if(grep(/^\s*($test)\s*$/,@cmds)>0);
				}
			}
		}
	}	
	if($nb{"llbd"}==0 && $nb{"dced"}==0 && VerifCommande("LLBD")) {
		Trace "il manque llbd/dced" if($debug);
		arret_ito(0);
		$code =  relance_llbd() + demarrage_ito(0);
		Trace "relance llbd+opc code=$code" if($debug);
	} elsif($nb{"opcctla"}==0 || $nb{"opcctla"}>1 || $nb{"opcmsgi"}==0 || $nb{"opcmsga"}==0
			|| opcctla_hs() || VerifTmp()) {
		Trace "problme opc" if($debug);
		arret_ito(0);
		$code = demarrage_ito(0);
		Trace "relance opc code=$code" if($debug);
	} else {
		Trace "Tout est ok" if($debug);
	}
	return $code;
}

my $code1 = 0;
my $code2 = 0;

if(-d "/var/tmp/opc_tmp") { # installation en cours
	my $headers = join("\n",
					   "To: $mail_addr",
					   "Subject: Installation ITO en cours sur $host",
					   "X-Mailer: ITO 5",
					   "Mime-Version: 1.0",
					   "Content-Transfer-Encoding: 8bit",
					   "Content-Type: text/plain; charset=iso-8859-1");
	my $texte = "\nITO est en cours d'installation sur $host\nVoir /var/tmp/opc_tmp\n\n";
	mail("$headers\n$texte","-F'ITO 5' -t");
	exit 0;
}

if(-f "/var/tmp/opc_stop") {
	my($code,@result) = opcctla("-status");
	if(!@result || $result[0] !~ /is currently not running/) {
		opcmsg("Control","opc_stop","ATTENTION : ITO DESACTIVE SUR CETTE MACHINE",
			   "critical","OpC");
		$code = arret_ito(0);
	}
	my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
	   $atime,$mtime,$ctime,$blksize,$blocks) = stat("/var/tmp/opc_stop");
	if(time()-$ctime>(24*60*60) && $date > 925 && $date < 935) {
		my $headers = join("\n",
						   "To: $mail_addr",
						   "Subject: ITO DESACTIVE SUR $host",
						   "X-Mailer: ITO 5",
						   "Mime-Version: 1.0",
						   "Content-Transfer-Encoding: 8bit",
						   "Content-Type: text/plain; charset=iso-8859-1");
		my $texte = "\nITO est dsactiv par /var/tmp/opc_stop\n\n";
		mail("$headers\n$texte","-F'ITO 5' -t");
	}
	exit 0;
}

if(-f $lock) { # OPC_ctl.pl tourne encore
	my $process = 'opcctla|opcmsgi|opcmsga|opcle|opcmona|opcacta';
	my @to_kill;
	for(grep(/$process/,`ps -ef`)) {
		next if(/^\s*\S+\s+$$\s+/);
		push(@to_kill,$1) if(/^\s*\S+\s+(\d+)/);
	}
	kill 9,@to_kill if(@to_kill);
	nettoie(OpcTmp());
	demarrage_ito(0);
} else {
	open(LOCK,">$lock");
	close(LOCK);
}

if(-d "$opclog/mgmt_sv") {
	$code2 = Traitement_serveur(1);
	Trace "opc_ctl code serveur=$code2" if($debug && $code2);
} elsif((@ARGV && $ARGV[0] eq '-force') || ($date > 623 && $date < 633)) {
	Trace "Arret force a $date" if($debug);
	arret_ito(0);
	nettoie(OpcTmp());
	relance_llbd();
	demarrage_ito(0);
}

$code1 = Traitement_noeud();
Trace "opc_ctl code noeud=$code1" if($debug && $code1);

my $message;
for(@fichiers_obligatoires) {
	if(!-f "/var/opt/OV/conf/OpC/$_") {
		$message .= "Fichier $_ absent\n";
	} elsif(-z "/var/opt/OV/conf/OpC/$_") {
		$message .= "Fichier $_ vide\n";
	}
}
if($message) {
	my $headers = join("\n",
					   "To: $mail_addr",
					   "Subject: Configuration ITO invalide sur $host",
					   "X-Mailer: ITO 5",
					   "Mime-Version: 1.0",
					   "Content-Transfer-Encoding: 8bit",
					   "Content-Type: text/plain; charset=iso-8859-1");
	my $texte = "\n$message\nVoir dans /var/opt/OV/conf/OpC sur $host\n\n";
	mail("$headers\n$texte","-F'ITO 5' -t");
}

unlink $lock if(-f $lock);

exit $code1 + $code2;

__END__
