#!/bin/sh
# OPC_WHAT_STRING="@(#)HP OpenView IT/Operations A.04.12 (01/08/99)"
##################################################################
#
# @(#) ITO Startup of GPM,  5/15/97, A.00.00
#
#  Purpose:  Select the appropiate path for the platform
#              and OS, verify gpm is available and execute.
#
#  Usage:   ito_gpm.sh
#
#  Note:  NONE 
#
#  Created By:  R. Johnson
#  Date:        15 May 1997
#
##################################################################
set_bin_path () {
###########################################################################
#  OS DEPENDENT BIN_PATHS
#
  PRODUCT="gpm"
  COMMAND="gpm -display $NODE_DISPLAY"
  SYS=`uname -s`         # System type
  REV=`uname -r`
  NODE=`uname -n`
  VUF="$SYS"
  if [ "$SYS" != "HP-UX" -a "$SYS" != "SunOS" -a "$SYS" != "AIX" -a -f /etc/.relid ] 
  then
    SYS="NCR"
    REV=`cat /etc/.relid | awk ' /RELEASE/ { print $3 }'` 
  fi
  if [ "$SYS" = "AIX" ]
  then
#    REV=`oslevel`
     REV=`uname -v`.`uname -r`
  fi
############################################################################
  if [ "$SYS" = "HP-UX" ]
  then
    if [ "`echo $REV| awk '/9\.0/'`" = "$REV" ]
    then
      BIN_PATH="/usr/perf/bin"
    elif [ "`echo $REV | awk '/10\./'`" = "$REV" ]
    then
      BIN_PATH="/opt/perf/bin" 
    elif [ "`echo $REV | awk '/11\./'`" = "$REV" ] 
    then
      BIN_PATH="/opt/perf/bin"
    fi
  fi
  if [ "$SYS" = "AIX" ]
  then
    BIN_PATH="/usr/lpp/perf/bin"
  fi
  if [ "$SYS" = "SunOS" ]
  then
    if [ "`echo $REV| awk '/4\.1/'`" = "$REV" ]
    then
      BIN_PATH="/usr/perf/bin"
      COMMAND="/usr/openwin/bin/xterm -display $NODE_DISPLAY -T Glance@$NODENAME -n Glance -e $BIN_PATH/glance &"
      PRODUCT=glance
    else
      BIN_PATH="/opt/perf/bin"
    fi
  fi
  if [ "$SYS" = "NCR" ]
  then
    BIN_PATH="/opt/perf/bin"
  fi
  if [ "`echo $SYS| awk '/SINIX/'`" = "$SYS" ]
  then
    if [ "`echo $REV| awk '/5\.4/'`" = "$REV" ]
    then
      BIN_PATH="/opt/perf/bin"
    fi
  fi
}  # End of Bin Path
##########################################################################
# MAIN
##############
if [ $# -gt 0 ]
then
  NODE_DISPLAY=$1
fi

set_bin_path

if [ -z "$BIN_PATH" ]
then
  echo "\n   Either GlancePlus is not supported on $SYS $REV "
  echo   "   or the integration script does not support $SYS $REV \n"
  exit 1
else
  if [ -x $BIN_PATH/$PRODUCT ]
  then
    if [ "$PRODUCT" = "glance" ]
    then
       $COMMAND
    else
       $BIN_PATH/$COMMAND 
    fi
  else
    echo "\n   GlancePlus is not installed on this System $NODE\n"
    exit 1
  fi
fi
