#!/usr/bin/sh
# OPC_WHAT_STRING="@(#)HP OpenView IT/Operations A.04.12 (01/08/99)"
###############################################################################
#
# File:          dist_del.sh
# Description:   
# Language:      Bourne shell
# Package:       N/A
#
# (c) Copyright Hewlett-Packard Co. 1993 - 1999
#
###############################################################################
# Parameter 1 : Threshold value in min
#             : Severitiy level in opcmsg {normal,warning,critical}	
#
# 
# Set up some defaults
MACH_TYPE=`uname -s`
PROGNAME=`basename $0`

BIN_DIR=/usr/bin
OS_DIR=/usr
OPT_DIR=/opt
VAR_DIR=/var/opt
ETC_DIR=/etc/opt

# localization
LANG_C=C
LANG_SJIS=ja_JP.SJIS
LANG_EUC=ja_JP.eucJP

# for agents we may need a different root directory e.g. in a cluster
# environment else it is the root directory
#
ROOT_DIR=${ROOT_DIR:-""}

# defined in every script - the version of this script
INST_OPCVERS=A.04.12

# prerequisites:
#---------------
#
# the paths
#
#   OPT_DIR	e.g. /opt
#   VAR_DIR	e.g. /var/opt
#   ETC_DIR	e.g. /etc/opt
#
# must be defined before using this module
#
# Naming Scheme
# <prog>_<name>_DIR	1 directory e.g. OV_<name>_DIR, OPC_<name>_DIR
# <name>_PATH		several directories delimited by ":"
#
TMP_DIR=${ROOT_DIR}/tmp/opc_tmp

#-------------------------------------
# generic paths
#-------------------------------------
# /opt/OV
OV_OPT_DIR=${OV_OPT_DIR:-${ROOT_DIR}${OPT_DIR}/OV}
OPC_OPT_DIR=${OPC_OPT_DIR:-${OV_OPT_DIR}}
# /var/opt/OV
OV_VAR_DIR=${OV_VAR_DIR:-${ROOT_DIR}${VAR_DIR}/OV}
OV_VAR_SH_DIR=${OV_VAR_SH_DIR:-${OV_VAR_DIR}/share}
OPC_VAR_DIR=${OPC_VAR_DIR:-${OV_VAR_DIR}}
# /etc/opt/OV
OV_ETC_DIR=${OV_ETC_DIR:-${ROOT_DIR}${ETC_DIR}/OV}
OV_ETC_SH_DIR=${OV_ETC_SH_DIR:-${OV_ETC_DIR}/share}
OPC_ETC_DIR=${OPC_ETC_DIR:-${OV_ETC_DIR}/share}

OV_NEWCFG_DIR=${OV_NEWCFG_DIR:-${OV_OPT_DIR}/newconfig}
OV_OLDCFG_DIR=${OV_OLDCFG_DIR:-${OV_OPT_DIR}/old}

# WWW
OV_WWW_DIR=$OV_OPT_DIR/www

# /opt/OV
OV_OPT10_DIR=${OV_OPT10_DIR:-${ROOT_DIR}${OPT10_DIR}/OV}
# /var/opt/OV
OV_VAR10_DIR=${OV_VAR10_DIR:-${ROOT_DIR}${VAR10_DIR}/OV}
OV_VAR10_SH_DIR=${OV_VAR10_SH_DIR:-${OV_VAR10_DIR}/share}
# /etc/opt/OV
OV_ETC10_DIR=${OV_ETC10_DIR:-${ROOT_DIR}${ETC10_DIR}/OV}
OV_ETC10_SH_DIR=${OV_ETC10_SH_DIR:-${OV_ETC10_DIR}/share}

# where to find the minimal SD binaries
OPC_SD_DIR=${OPC_SD_DIR:-/usr/sbin}

#-------------------------------------
# OpenView paths
#-------------------------------------
OV_BIN_DIR=${OV_BIN_DIR:-${OV_OPT_DIR}/bin}
OV_TMP_DIR=${OV_TMP_DIR:-${OV_VAR_DIR}/tmp}
OV_LOG_DIR=${OV_LOG_DIR:-${OV_VAR_DIR}/log}
OV_CFG_DIR=${OV_CFG_DIR:-${OV_ETC_DIR}/share/conf}
OV_ALT_CFG_DIR=${OV_ALT_CFG_DIR:-${OV_ETC_DIR}/share/\#conf}

#-------------------------------------
# ITO Server Paths
#-------------------------------------
# /usr/OV/bin/OpC
OPCSVR_BIN_DIR=${OPCSVR_BIN_DIR:-${OPC_OPT_DIR}/bin/OpC}
# /usr/OV/bin/OpC/install
OPCSVR_INST_DIR=${OPCSVR_INST_DIR:-${OPCSVR_BIN_DIR}/install}
# /opt/OV/lib
OPCSVR_LIB_DIR=${OPCSVR_LIB_DIR:-${OPC_OPT_DIR}/lib}
# /opt/OV/nls
OPCSVR_NLS_DIR=${OPCSVR_NLS_DIR:-${OPCSVR_LIB_DIR}/nls}
# /opt/OV/include
OPCSVR_INC_DIR=${OPCSVR_INC_DIR:-${OPC_OPT_DIR}/include}
# /usr/OV/bin/OpC/utils
OPCSVR_UTIL_DIR=${OPCSVR_UTIL_DIR:-${OPCSVR_BIN_DIR}/utils}
# /usr/OV/bin/OpC/agtinstall
OPCSVR_AGTINST_DIR=${OPCSVR_AGTINST_DIR:-${OPCSVR_BIN_DIR}/agtinstall}
# /etc/opt/OV/share/lrf
OPCSVR_OPC_DIR=${OPCSVR_OPC_DIR:-${OPC_OPT_DIR}/OpC}
OPCSVR_NEWCFG_DIR=${OPCSVR_NEWCFG_DIR:-${OV_NEWCFG_DIR}/OpC}
OPCSVR_OLDCFG_DIR=${OPCSVR_OLDCFG_DIR:-${OV_OLDCFG_DIR}/OpC}
OPCSVR_HELP_DIR=${OPCSVR_HELP_DIR:-${OV_VAR_DIR}/share/help}

# /etc/opt/OV directories
OPCSVR_LRF_DIR=${OPCSVR_LRF_DIR:-${OPC_ETC_DIR}/lrf}
OPCSVR_REG_DIR=${OPCSVR_REG_DIR:-${OPC_ETC_DIR}/registration}

# /var/opt/OV/share/databases
OPCSVR_DB_DIR=${OPCSVR_DB_DIR:-${OPC_VAR_DIR}/share/databases/OpC}
# /var/opt/OV/share/databases/OpC/mgd_node/vendor
OPCSVR_VEND_DIR=${OPCSVR_DB_DIR}/mgd_node/vendor
# /var/opt/OV/share/databases/OpC/mgd_node/customer
OPCSVR_CUST_DIR=${OPCSVR_DB_DIR}/mgd_node/customer

# dynamic paths
OPCSVR_TMP_DIR=${OPCSVR_TMP_DIR:-${OPC_VAR_DIR}/share/tmp/OpC}
OPCSVR_LOG_DIR=${OPCSVR_LOG_DIR:-${OPC_VAR_DIR}/log/OpC}
OPCSVR_CFG_DIR=${OPCSVR_CFG_DIR:-${OPC_ETC_DIR}/conf/OpC}
OPCSVR_APPL_DIR=${OPCSVR_APPL_DIR:-${OPC_VAR_DIR}/share/tmp/OpC_appl}
OPCSVR_MAN_DIR=${OPCSVR_MAN_DIR:-${OPC_OPT_DIR}/man}

OPCSVR_INFO_F=${OPCSVR_INFO_F:-${OPCSVR_INST_DIR}/opcsvinfo}

# Config file needed by distributed GUI client
OPC_GUICLT_MSV_F=${OPC_GUICLT_MSV_F:-${OV_CFG_DIR}/opc_guiclt_msv}
OPC_GUICLT_TMP_MSV_F=${OPC_GUICLT_TMP_MSV_F:-/tmp/opc_guiclt_msv}

# DB config file
OVDB_CONFIG_FILE=${OVDB_CONFIG_FILE:-${OV_CFG_DIR}/ovdbconf}

#-------------------------------------
# ITO Agent Paths
#-------------------------------------
# /usr/OV/bin/OpC/s700
OPCAGT_BIN_DIR=${OPCAGT_BIN_DIR:-${OPC_OPT_DIR}/bin/OpC}
OPCAGT_LIB_DIR=${OPCAGT_LIB_DIR:-${OPC_OPT_DIR}/lib}
OPCAGT_NLS_DIR=${OPCAGT_NLS_DIR:-${OPCAGT_LIB_DIR}/nls}
OPCAGT_INC_DIR=${OPCAGT_INC_DIR:-${OPC_OPT_DIR}/include}
# /usr/OV/bin/OpC/s700/utils
OPCAGT_UTIL_DIR=${OPCAGT_UTIL_DIR:-${OPCAGT_BIN_DIR}/utils}
# /usr/OV/bin/OpC/s700/install
OPCAGT_INST_DIR=${OPCAGT_INST_DIR:-${OPCAGT_BIN_DIR}/install}

# /var/opt/OV/bin/OpC/monitor
OPCAGT_MON_DIR=${OPCAGT_MON_DIR:-${OPC_VAR_DIR}/bin/OpC/monitor}
# /opt/OV/bin/OpC/actions
OPCAGT_ACT_DIR=${OPCAGT_ACT_DIR:-${OPC_VAR_DIR}/bin/OpC/actions}
# /var/opt/OV/bin/OpC/cmds
OPCAGT_CMD_DIR=${OPCAGT_CMD_DIR:-${OPC_VAR_DIR}/bin/OpC/cmds}

# dynamic paths
OPCAGT_LOG_DIR=${OPCAGT_LOG_DIR:-${OPC_VAR_DIR}/log/OpC}
OPCAGT_CFG_DIR=${OPCAGT_CFG_DIR:-${OPC_VAR_DIR}/conf/OpC}
OPCAGT_TMP_DIR=${OPCAGT_TMP_DIR:-${OPC_VAR_DIR}/tmp/OpC}
OPCAGT_TMPBIN_DIR=${OPCAGT_TMPBIN_DIR:-${OPCAGT_TMP_DIR}/bin}
OPCAGT_TMPCFG_DIR=${OPCAGT_TMPCFG_DIR:-${OPCAGT_TMP_DIR}/conf}
OPCAGT_NEWCFG_DIR=${OPCAGT_NEWCFG_DIR:-${OV_NEWCFG_DIR}/OpC}
OPCAGT_OLDCFG_DIR=${OPCAGT_OLDCFG_DIR:-${OV_OLDCFG_DIR}/OpC}

# info files
OPCAGT_NDINFO_F=${OPCAGT_NDINFO_F:-${OPCAGT_CFG_DIR}/nodeinfo}
OPCAGT_INFO_F=${OPCAGT_INFO_F:-${OPCAGT_INST_DIR}/opcinfo}
OPCAGT_NETLS_F=${OPCAGT_NETLS_F:-${OPCAGT_CFG_DIR}/opcnetls}
OPCAGT_MGRCONF_F=${OPCAGT_MGRCONF_F:-${OPCAGT_CFG_DIR}/mgrconf}
OPCAGT_UPD_F=${OPCAGT_UPD_F:-${OPCAGT_TMP_DIR}/update}
OPCAGT_CLIENT_F=${OPCAGT_CLIENT_F:-${OPCAGT_INST_DIR}/cfg.clients}
OPCAGT_MGMTSV_F=${OPCAGT_MGMTSV_F:-${TMP_DIR}/mgmt_sv.dat}
#
# commands
#
OPCMON=${OPCAGT_BIN_DIR}/opcmon
OPCMSG=${OPCAGT_BIN_DIR}/opcmsg

VUE_DIR=/etc/vue
VUE_USR_DIR=/usr/vue
VUE_ETC_DIR=/etc/vue
VUE_VAR_DIR=/var/vue
CDE_USR_DIR=/usr/dt
CDE_ETC_DIR=/etc/dt
CDE_VAR_DIR=/var/dt

#-------------------------------------
# paths
#-------------------------------------
SYSTEM_PATH=${SYSTEM_PATH:-"/bin:/usr/bin:/sbin:/usr/sbin:/etc:/usr/etc:/usr/ucb"}
OV_PATH=${OV_BIN_DIR}
OPCSVR_PATH=${OPCSVR_BIN_DIR}:${OPCSVR_AGTINST_DIR}:${OPCSVR_INST_DIR}
OPCAGT_PATH=${OPCAGT_BIN_DIR}:${OPCAGT_INST_DIR}:${OPCAGT_MON_DIR}:${OPCAGT_ACT_DIR}:${OPCAGT_CMD_DIR}

# program name
APPLNAME=ITO
LONG_APPLNAME="HP OpenView IT/Operations 4.0"

# common umask value
umask 022

# print_msg() updates EXIT_CODE automatically using
# this utility function for script exit value.
# it keeps the worst exit code in ${EXIT_CODE}
#--------------------------------------------------
SUCCESS=0
FAILURE=1
WARNING=2

EXIT_CODE=${SUCCESS}

eval_exit()
{
  exit_new=$1

  if [ ${exit_new} -eq ${FAILURE} ]
  then
    EXIT_CODE=${FAILURE}
  elif [ ${exit_new} -eq ${WARNING} -a ${EXIT_CODE} -eq ${SUCCESS} ]
  then
    EXIT_CODE=${WARNING}
  fi

  return 0
}

#-------------------------------
#
# print_msg: print message to stderr/stdout and optional to logfile
#
#-------------------------------
# usage: print_msg <mode> <messages> ...
#
# <mode>: ( <type> | <fd> | <type><fd> | "." )
#
#        <type>:     use this type with <fd> = 2
#        <fd>:       use this fd with <type> = I
#        <type><fd>: use type and fd
#        ".":        use empty prefix and fd of last call
#
# <type>: ( "I" | "E" | "W" | "N" | "U" )
#          defines message prefix:
#          I)nfo:    "         "
#          E)rror:   "ERROR:   "
#          W)arning: "WARNING: "
#          N)ote:    "NOTE:    "
#          U)sage:   "USAGE:   "
#
# <fd>: file descriptor for output (2 = stderr, 1 = stdout)
#
# <messages>: the first message argument will be printed with
#             the selected prefix. Optionally following message
#             arguments will be printed in seperate lines with
#             an empty prefix.
# 
#-------------------------------
# examples:
#
# 1.) print_msg W "Something went wrong"
#
#     output to stderr: WARNING: Something went wrong
#
# 2.) print_msg N1 "Be aware that"
#     print_msg .  "something has happened"
#
#     output to stdout: NOTE:    Be aware that
#                     :          something has happened
#
# 3.) print_msg E2 "this is" "an" "error"
#
#     output to stderr: ERROR:   this is
#                     :          an
#                     :          error
#
#-------------------------------
# logging:
#
# default: logging is disabled
# enable logging with:  enable_logging <logfile>
# disable logging with: disable_logging
#
# if logging is enabled, all output of print_msg
# is also printed into the specified logfile.
#    
#--------------------------------
# exit codes:
#
# print_msg calls the shlib_misc:eval_exit() function
# with an appropriate parameter 
# in order to keep the EXIT_CODE up to date
#
#--------------------------------
MSG_LOGFILE=""

MSG_INFO="I"
MSG_ERROR="E"
MSG_WARN="W"
MSG_NOTE="N"
MSG_USAGE="U"
MSG_QUERY="Q"
MSG_LOG="L"    # goes to log only if enabled
MSG_SAME="."

#
# prefixes must have length 9
#                 123456789
      MSG_PREFIX="         "
 MSG_PREFIX_INFO="         "
MSG_PREFIX_ERROR="ERROR:   "
 MSG_PREFIX_WARN="WARNING: "
 MSG_PREFIX_NOTE="NOTE:    "
MSG_PREFIX_USAGE="USAGE:   "
MSG_PREFIX_QUERY="-------> "
MSG_PREFIX_LOG="LOG:     "

MSG_FD=2

print_msg()
{
  mode="$1"; shift

  if [ "$mode" = "$MSG_SAME" ]
  then
    type="$MSG_SAME"
  else
    type=`echo "$mode" | sed 's/^[^A-Z]*\([A-Z]\).*$/\1/'`
    MSG_FD=`echo $mode"_2" | sed 's/^[^0-9]*\([0-9][0-9]*\).*$/\1/'`
  fi

  prefix="$MSG_PREFIX"

  # set prefix
  case "$type" in
    $MSG_INFO)
      prefix="$MSG_PREFIX_INFO"
      ;;
    $MSG_ERROR)
      prefix="$MSG_PREFIX_ERROR"
      ;;
    $MSG_WARN)
      prefix="$MSG_PREFIX_WARN"
      ;;
    $MSG_NOTE)
      prefix="$MSG_PREFIX_NOTE"
      ;;
    $MSG_USAGE)
      prefix="$MSG_PREFIX_USAGE"
      ;;
    $MSG_QUERY)
      prefix="$MSG_PREFIX_QUERY"
      ;;
    $MSG_LOG)
      prefix="$MSG_PREFIX_LOG"
      ;;
    $MSG_SAME)
      prefix="$MSG_PREFIX"
      ;;
  esac

  for msg in "$@" ; do
    # concatenate with prefix
    msg="$prefix$msg"
    prefix="         "
  
    if [ "$type" != "$MSG_LOG" ]
    then
      # output message
      echo "$msg" >&$MSG_FD
    fi
  
    # if logging is enabled log the message
    if [ -n "$MSG_LOGFILE" ]
    then
      echo "$msg" >> ${MSG_LOGFILE}
    fi

  done

  # set EXIT_CODE
  case "$type" in
    $MSG_ERROR)
      eval_exit ${FAILURE}
      ;;
    $MSG_WARN)
      eval_exit ${WARNING}
      ;;
  esac
}

enable_logging()
{
  MSG_LOGFILE="$1"
}

disable_logging()
{
  MSG_LOGFILE=""
}

############################################################
# Usage

usage () 
{
 print_msg U1 "${PROGNAME} <pending_time> <severity_level>" 
 exit 1
}

if [ $# -ne 2 -o "$1" = "-?" -o "$1" = "-h" ]
then
    usage
fi

DELAY=$1
SEVERITY=$2

#
#

OPC_TIME_DIFF=${OPCSVR_BIN_DIR}/utils/opc_time_diff
OPC_IP_ADDR=${OPCSVR_INST_DIR}/opc_ip_addr
OPC_DISTRIB=${OPCSVR_TMP_DIR}/distrib
TIMESTAMP=timestamp
TMP_U=/tmp/distrib_tmp_u
TMP_S=/tmp/distrib_tmp_s

############################################################
# Main thread
#

cd $OPC_DISTRIB
touch $TIMESTAMP $TMP_U $TMP_S
 
for all_files in `ls -1 ???????.* ????????.* | grep -v opc 2>/dev/null` 
	do 
	$OPC_TIME_DIFF $all_files $TIMESTAMP $DELAY >> $TMP_U
	done

cat $TMP_U | awk '{ print substr($1,1,index($1,".")-1) } ' | sort -u >> $TMP_S

print_msg I "Checked for pending template distributions"
print_msg I "------------------------------------------"
if [ -s ${TMP_S} ]; then
  print_msg I "found entries for:"
else
  print_msg I "nothing found"
fi
for all_hosts in `cat $TMP_S`
	do 
 	  node=`${OPC_IP_ADDR} -r $all_hosts | awk ' { print $1 } '`
	  $OPCMSG s=$SEVERITY a=distrib msg_grp=OpC o=Template \
	  msg_text="Template distribution still pending" node=$node
          print_msg I "${node}"
   	done

rm $TIMESTAMP $TMP_U $TMP_S

exit 0

############################################################
