#!/serveur/dp/bin/perl -w

# 	$Id: TIV_tmr.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance des TMR Tivoli connects.
#
# usage : TIV_tmr.pl <nom_template>
#
# Code retour :
#		renvoie le nombre de TMR non connectes, => pb si > 0
#
# exemple :  TIV_tmr.pl TIV_TMR_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# Vrification des TMR.
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $nbr = 0;
	my @tableau = grep(/\.1\./,wlookup("-ar ManagedNode"));

	print "\nNombre de serveurs trouves : ", scalar( @tableau ), "\n";
	print "Serveur(s) TMR KO non connecte(s) ou non trouve(s) :\n\n";

	for(@tableau) {
		my($TMR) = split (/\s+/);
		my ($ping) = wping("$TMR 2>&1");
		if($ping !~ /is alive/) {
			$nbr++;
			print "------------------------------------------------------------\n";
			print " Serveur : $TMR\n";
			print "------------------------------------------------------------\n";
			print "wping $TMR (test Tivoli) :\n";
			print "$TMR : KO <<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<<\n";
			print "\nping -s $TMR 64 10 (test reseau) :\n";
			my ($Retour) = ping("-s $TMR 64 10");
			print "$Retour\n";
		}
	}

	print "------------------------------------------------------------\n";
	print "\nNombre de serveur(s) TMR KO : $nbr\n\n";
	return $nbr;
}

# ---------------------------------------------------------------
# lecture des parametres : process a surveiller
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
