#!/serveur/dp/bin/perl -w

# 	$Id: TIV_log.pl,v 2.1 2001/04/09 07:55:30 p004184 Exp $	

# ---------------------------------------------------------------
#
# Surveillance des fichiers log de Tivoli
#
# Fusionne les fichiers log (*.opc) de toutes les applications
# distribues par Tivoli.
#
# usage : TIV_log.pl <nom template>
#
# Code retour :
#		0: ok, 1: erreur script, 2: alerte ITO
#
# exemple : TIV_log.pl TIV_log
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;
use AnyDBM_File;
use Fcntl ':flock';
use Fcntl;
use POSIX 'strftime'; 
use Time::Local; 

my $map = "/etc/auto_reference";
my $repertoire = "/home/reference";
my $log = "/var/tmp/opc_tivlog.log";
my(%info);

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# filtre le bloc de lignes
# ---------------------------------------------------------------
sub EcritBloc {
	my($ficlog,$appli,@bloc) = @_;
	return 0 if(!@bloc || grep(/:FAILED/,@bloc)==0);
	my $code = 0;
	my @sous_bloc;
	print $ficlog "\nApplication:   $appli\n";
	for(@bloc) {
		next if(/^Operation:/);
		if(@sous_bloc && /------/) {
			if (grep(/^File Package:/,@sous_bloc)>0
				|| grep(/:SUCCESS|^script complete: status = 0/,@sous_bloc)==0) {
				print $ficlog @sous_bloc;
				$code = 2;
			}
			undef @sous_bloc;
		}
		push(@sous_bloc,$_);
	}
	if(@sous_bloc
	   && (grep(/^File Package:/,@sous_bloc)>0
		   || grep(/:SUCCESS|^script complete: status = 0/,@sous_bloc)==0)) {
		print $ficlog @sous_bloc;
		$code = 2;
	}
	print $ficlog "\n";
	return $code;
}

# ---------------------------------------------------------------
# filtre les fichiers dj lus
# retrouve la dernire position
# concatne tout en ajoutant le nom de l'application
# ---------------------------------------------------------------
sub TraiteFic {
	my($ficlog,$fic,$appli) = @_;
	my $code = 0;
	Trace "TraiteFic $fic" if($debug);

	my($date_log,$taille_log,$inode_log) = (0,0,0);
	($date_log,$taille_log,$inode_log) = split(/\t+/,$info{$fic},3) if($info{$fic});
	my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat($fic);

	Trace "$date_log!=$st_mtime || $inode_log!=$st_ino || $taille_log!=$st_size" if($debug);
	if(($date_log!=$st_mtime || $inode_log!=$st_ino || $taille_log!=$st_size)
	   && $st_size>0) {
		Trace "on prend $fic" if($debug);
		if(open(LOGIN,"<$fic")) {
			$taille_log = 0 if($inode_log!=$st_ino || $taille_log>$st_size);
			seek(LOGIN,$taille_log,0);
			my @log = <LOGIN>;
			close(LOGIN);
			my @bloc;
			for(@log) {
				if(/File Package|=============/) {
					my $code2 = EcritBloc($ficlog,$appli,@bloc);
					$code = $code2 if($code2>$code);
					undef @bloc;
				}
				push(@bloc,$_) if(!/=============/);
			}
			my $code2 = EcritBloc($ficlog,$appli,@bloc);
			$code = $code2 if($code2>$code);
		} else {
			print "open $fic : $!\n";
			$code = 1;
		}
	}
	$info{$fic} = "$st_mtime\t$st_size\t$st_ino";
	return $code;
}

# ---------------------------------------------------------------
# cherche les fichiers log Tivoli pour toutes les applications
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	my @applications;
	my $dir = OpcLog();
	my $base = "$dir/filtre_tiv.db";
	my $lock = "$dir/filtre_tiv.lock";
	open(LOCK,">>$lock") && flock(LOCK,LOCK_EX)
		&& tie(%info,'NDBM_File',$base,O_RDWR|O_CREAT, 0640);
	unlink($log) if(-f $log);

	if(-d $repertoire) {
		if(open(LOGOUT,">$log")) {
			if(open(MAP,"<$map")) {
				while(<MAP>) {
					my($appli) = split;
					next if($appli =~ /^gdgbis$/);
					next if($appli =~ /^gdgfor$/);
					next if($appli =~ /^gdgre7$/);
					next if($appli =~ /^gdg$/);
					Trace "appli=$appli" if($debug);
					foreach my $fic (glob("$repertoire/$appli/logs/*.opc")) {
						my $code2 = TraiteFic(\*LOGOUT,$fic,$appli);
						$code = $code2 if($code2>$code);
					}
				}
				close(MAP);
			} else {
				print "open $map : $!\n";
				$code = 1;
			}
			close(LOGOUT);
		} else {
			print "open $log : $!\n";
			$code = 1;
		}
	} else {
		print "Rpertoire $repertoire non trouv\n";
		$code = 1;
	}

	untie(%info);
	flock(LOCK,LOCK_UN);
	close(LOCK);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($NomTemplate && $debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
