#!/serveur/dp/bin/perl -w

# 	$Id: PROC_top.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Liste des process consommant la CPU
#		
# usage : PROC_top.pl nom_template
#
# Code retour :
#		0 : ok, 1 : problme dans le script
#
# exemple : PROC_top.pl cpu_util
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my $count;

# ---------------------------------------------------------------
# tout est base sur un top qui renvoie $user,$pid,$time,$pcpu,@args
# (tri sur pcpu)
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my @result = top();
	printf("%10s %7s %8s %8s %s\n","USER","PID","TIME","CPU","CMD");
	my $i = 1;
	for($i = 1; $i<=$count; $i++) {
		if(defined($result[$i])) {
			my($user,$pid,$time,$pcpu,@args) = split(/\s+/,$result[$i]);
			my $args = join(' ',@args);
			printf("%10s %7s %8s %8s %s\n",$user,$pid,$time,$pcpu,$args);
		}
	}
	return 0;
}

# ---------------------------------------------------------------
# lecture des parametres : liste des doublons user/processus
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	my $code = 0;
	if(@ARGV) {
		$count = shift(@ARGV);
	} else {
		Trace "Erreur de parametrage";
		$code = 1;
	}
	return $code;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
