#!/serveur/dp/bin/perl -w

# 	$Id: Mailq.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance du bon fonctionnement et de la queue d'attente
# de sendmail
#		
# usage : Mailq.pl nom_template <nombre maxi en attente>
#		nombre maxi en attente : nombre de requtes dans la
#				queue d'attente de sendmail  partir duquel on
#				dclenche une alerte. Il doit tre suprieur  2.
#
# Code retour :
#		0 : ok, 2 : erreur sendmail
#		3.. : nombre de requtes en attente si suprieur au seuil
#
# exemple : Mailq.pl MailQueueLength 30
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = 0;

my $max_req;

# ---------------------------------------------------------------
# On appelle sendmail qui liste la queue d'attente
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my ($code,@result) = sendmail("-bp");
	if($code != 0) {
		$code = 2;
		print @result;
	} elsif($result[0] =~ /Mail Queue \((\d+) request/ && $1>$max_req) {
		$code = $1 ;
		my %nb;
		my $prec;
		for(@result) {
			next if(/^$/);
			next if(/Sender\/Recipient/);
			if(/Mail Queue \((\d+) request/) {
				print "$1 requetes en attente dont :\n\n";
			} elsif(/\((.+)\)\s+(\S+)/) {
				$nb{"$1 $2"}++;
			} elsif(/\((.+)\)\s*$/) {
				$prec = $1;
			} elsif($prec && /(\S+)/) {
				$nb{"$prec $1"}++;
				undef $prec;
			}
		}
		for(sort { $nb{$b} > $nb{$a} } keys %nb) {
			my $a = my $a2 = $_;
			next if($nb{$a} == 0);
			$a2 =~ s/\s+//g;
			my $a3 = quotemeta $a2;
			for(keys %nb) {
				my $b = my $b2 = $_;
				next if($nb{$b} == 0);
				next if($a eq $b);
				$b2 =~ s/\s+//g;
				$b2 = $1 if($b2 =~ /(.*renault\.fr)[A-Z0-9]+$/);
				my $b3 = quotemeta $b2;
				if($a2 =~ /^$b3/) {
					$nb{$a} += $nb{$b};
					$nb{$b} = 0;
				} elsif($b2 =~ /^$a3/) {
					$nb{$b} += $nb{$a};
					$nb{$a} = 0;
				}
			}
		}
		for(sort { $nb{$b} > $nb{$a} } keys %nb) {	# tri sur le nombre
			next if($nb{$_} == 0);
			printf "%5d   %s\n",$nb{$_},$_;
		}
	} else {
		print @result;
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	if(@ARGV) {
		$max_req = shift(@ARGV);
	} else {
		Trace "Erreur parametrage";
		return 1;
	}
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
