#!/serveur/dp/bin/perl -w

# 	$Id: MAIL_ala.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Envoi de mails lors des alarmes
#
# Ce programme ne fait que transmettre les arguments au serveur
# MAIL_serv.pl qu'il lance si besoin.
#		
# ---------------------------------------------------------------

require 5.002;
use strict;
use Socket;

sub Log {
	my @message = @_;
	chomp(my $date = `date`);
	open(LOG,">>/var/opt/OV/log/OpC/opc.log");
	print LOG "$date $0 [$$] @message";
	close(LOG);
}

my @param = @ARGV;

# ---------------------------------------------------------------
# Relance du serveur si besoin.
# ATTENTION : il faut que ce soit le fils qui lance le serveur
# sinon on reste en prise sur un opcttnsm qui bloque les autres
# notifications.
# ---------------------------------------------------------------
my $serveur = 0;
my @ps = `ps -ef`;
for(@ps) {
	$serveur++ if(/MAIL_serv/);
}
if($serveur==0) {
	Log("RELANCE SERVEUR MAIL POUR\n@param\n");
	my $pid;
	if (!defined($pid = fork)) {
		Log("erreur fork: $!\n");
		exit 2;
	} elsif ($pid) { # I'm the parent
		sleep 20;
	} else { # I'm the child
		exec("/opt/OV/bin/OpC/extern_intf/MAIL_serv.pl");
	}
}

my $remote  = 'localhost';
my $port    = 23456;  # random port
my $iaddr = inet_aton($remote) || Log("erreur locating $remote : $!\n");
my $paddr = sockaddr_in($port, $iaddr) || Log("erreur sockaddr_in $port,$iaddr : $!\n");
my $proto = getprotobyname('tcp') || Log("erreur getprotobyname tcp : $!\n");

if($iaddr && $paddr && $proto) {
	if(socket(SOCK, PF_INET, SOCK_STREAM, $proto)) {
		if(connect(SOCK, $paddr)) {
			for(@param) {
				print SOCK "$_\n" || Log("print socket : $!\n");
			}
		} else {
			Log("erreur connect : $!\n");
		}
		close (SOCK)            || die "close: $!";
	} else {
		Log("erreur socket $proto : $!\n");
	}
}

exit 0;

__END__
