#!/serveur/dp/bin/perl -w

# 	$Id: IO_sur.pl,v 2.1 2001/01/04 07:23:28 legranau Exp $	

# ---------------------------------------------------------------
#
# Surveillance des IO sur les disques avec iostat
#
# usage : IO_sur.pl <nom_template>
#
# Codes retour :
#		0 : ok
#		1 : erreur programme
#		2 : alarme ITO
#
# exemple : IO_sur.pl IO_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my $disques;

# ---------------------------------------------------------------
# tout est base sur un iostat -x
# Pour tre en anomalie il faut :
# svc_t>1000
# wait>5
# actv>20
# w>15
# b est cumulatif donc on ne le surveille pas
# Si les stats sont  zro (sauf svc_t), c'est un fs temporaire (cdrom, etc)
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my ($code,@result) = iostat("-x");
	print "Erreur iostat code=$code\n@result" if($code!=0);
	my $entete;
	for(@result) {
		next if(/^(\s+|fd|nfs)/);
		chomp(my $ligne = $_);
		my($disk,$rs,$ws,$Kr,$Kw,$wait,$actv,$svc_t,$w,$b) = split(/\s+/);
		my $reason;
		 if(/^(disk|device)/) {
			 $entete = "\nLes disques suivants sont en anomalie :\n\n$ligne";
		 } else {
			 next if($rs+$ws+$Kr+$Kw+$wait+$actv+$w+$b==0);
			 $reason .= "svc_t>1000 " if($svc_t && $svc_t>1000);
			 $reason .= "wait>5 " if($wait && $wait>5);
			 $reason .= "actv>20 " if($actv && $actv>20);
			 $reason .= "w>15 " if($w && $w>15);
			 if($reason) {
				 print "$entete\n" if($code<2);
				 print "$ligne      $reason\n";
				 $code = 2;
				 $disques = "$disques,$disk" if($disques);
				 $disques = $disk if(!$disques);
			 }
		 }
	}
	print "\nAucune anomalie\n" if($code==0);
	$disques = "aucun" if($code==0);
	print "\n";
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO -option disk=$disques");
	exit 0;
}

__END__
