#!/serveur/dp/bin/perl -w

# 	$Id: CRON_ana.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Rcupration des informations d'un job dans le fichier log de cron.
#		On prend les 3 lignes concernant le pid demand.
#
# usage : CRON_ana.pl <pid>
#       pid : pid du job dont on veut les infos
#
# exemple : CRON_ana.pl 12345
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my $pid;

# ---------------------------------------------------------------
# Cette fct affiche les lignes du fichier log correspondant au
# job. On prend les 3 dernires lignes pour le pid demand.
# Le format des lignes est le suivant :
# > CMD commande
# > user pid infos
# < user pid infos code_retour_si_erreur
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my @ligne = (" "," "," ");
	my $code = 0;
	my $cmd = "Commande non trouvee";
	my $fic = CronLog();
	if(open(LOG,"<$fic")) {
		while(<LOG>) {
			next if(!/^[<>]/);
			if(/^>\s+CMD:/) {
				$cmd = $_;
			} elsif(/^>\s+\S+\s+(\d+)/ && $1 == $pid) {
				$ligne[1] = $_;
				$ligne[0] = $cmd;
			} elsif(/^<\s+\S+\s+(\d+)/ && $1 == $pid) {
				$ligne[2] = $_;
			}
		}
		close(LOG);
		print "@ligne\n";
	} else {
		print "open $fic : $!\n";
		$code = 1;
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : pid
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	my $nb = @ARGV;
	if($nb!=1) {
		Trace "Erreur parametres @ARGV";
		return 1;
	}
	$pid=shift(@ARGV);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
#my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

#Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
# if($NomTemplate eq "bidon") {
# 	exit $RetourITO;
# } else {
# 	opcmon("$NomTemplate=$RetourITO");
# 	exit 0;
# }

exit $RetourITO;

__END__
