#!/serveur/dp/bin/perl -w

# 	$Id: VM_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance de Volume Manager
#
# Surveillance de vxconfigd, des dmons vxiod, des disques,
# et bien sr des volumes...
#		
# usage : VM_sur.pl nom_template
#
# Code retour :
#		0 : ok, 2 : alarme ITO
#
# exemple : VM_sur.pl VM_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# bas sur 'vxdctl mode' et 'vxiod' pour les dmons VM
# vrifie prsence de vxconfigd et vxnotify
# ---------------------------------------------------------------
sub traite_demons {
	Trace "Traitement demons" if($debug);
	my($code1,@result1) = vxdctl("mode");
	Trace @result1 if($debug);
	Trace "Erreur lors de l'execution du vxdctl" if($code1 != 0);
	for(@result1) {
		if(! /^mode: enabled$/) {
			$code1 = 2;
			print "vxdctl : $_\n";
		}
	}
	my($code2,@result2) = vxiod();
	Trace @result2 if($debug);
	Trace "Erreur lors de l'execution du vxiod" if($code2 != 0);
	for(@result2) {
		if(/^(\d+) volume I\/O daemons running$/) {
			if($1 == 0) {
				$code2 = 2;
				print "vxiod : $_\n";
			}
		} else {
			$code2 = 2;
			print "vxiod : $_\n";
		}
	}
 	my @process = ps("-e");
	my $manque = 22;
	for(@process) {
		next if(/PID/);
		my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
		next if(!$pid || $pid == $$);
		$manque -= 20 if($name =~ /^vxconfig/);
		$manque -= 2 if($name =~ /^vxnotify/);
	}
	print "vxconfig : le demon ne tourne pas\n" if($manque > 10);
	print "vxnotify : le demon ne tourne pas\n" if($manque%10 > 0);
	return $code1 + $code2 + $manque;
}

# ---------------------------------------------------------------
# bas sur le rsultat d'un vxdisk.
# Le status error signifie qu'un disque n'est pas sous le contrle
# de VM...
# ---------------------------------------------------------------
sub traite_disques {
	Trace "Traitement disques" if($debug);
	my($code,@result) = vxdisk("list");
	Trace @result if($debug);
	print "\nDisques en anomalie :\n\n";
	for(@result) {
		next if(/^DEVICE/);
		next if(/^$/);
		my $ligne = $_;
		my($slice,$type,$disk,$group,@status) = split(/\s+/,$ligne);
		my $status = join(' ',@status);
		if($status =~ /^(failed|failing)/) {
			$code = 2;
			print "$ligne\n";
		}
	}
	print "Aucun\n" if($code == 0);
	return $code;
}

# ---------------------------------------------------------------
# bas sur le rsultat d'un vxprint.
# ---------------------------------------------------------------
sub traite_volumes {
	Trace "Traitement volumes" if($debug);
	my($code,@result) = vxprint("-A");
	Trace @result if($debug);
	Trace "Erreur lors de l'execution du vxprint" if($code != 0);
	print "\nDevices en anomalie :\n\n";
	for(@result) {
		next if(/^TY/);
		next if(/^Disk group:/);
		next if(/^$/);
		my $ligne = $_;
		my($type,$device,$assoc,$kstate,$length,$ploffs,$state) = split(/\s+/,$ligne);
		if($type eq 'dg') {				# disk group
			if($kstate ne '-' || $state ne '-') {
				$code = 2;
				print "$ligne\n";
			}
		} elsif($type eq 'dm') {		# disques physiques
			if($kstate ne '-' || $state !~ /^(RESERVED|-|SPARE)$/) {
				$code = 2;
				print "$ligne\n";
			}
		} elsif($type eq 'v') {			# volume
			if($kstate ne 'ENABLED' || $state ne 'ACTIVE') {
				$code = 2;
				print "$ligne\n";
			}
		} elsif($type eq 'pl') {		# plexes
			if($kstate ne 'ENABLED' || $state !~ /^(ACTIVE|SYNC|LOG)$/) {
				$code = 2;
				print "$ligne\n";
			}
		} elsif($type eq 'sd') {		# subdisks (partitions)
			if($kstate ne 'ENABLED' || $state ne '-') {
				$code = 2;
				print "$ligne\n";
			}
		}
	}
	print "Aucun\n" if($code == 0);
	Trace "code=$code" if($debug);
	return $code;
}

# ---------------------------------------------------------------
# bas sur vxdg list
# ---------------------------------------------------------------
sub traite_groupes {
	Trace "Traitement groupes" if($debug);
	my($code,@result) = vxdg("list");
	Trace @result if($debug);
	print "\nGroupes de disque en anomalie :\n\n";
	for(@result) {
		next if(/^NAME/);
		next if(/^$/);
		my $ligne = $_;
		my($groupe,$state,$id) = split(/\s+/,$ligne);
		if($state ne 'enabled') {
			$code = 2;
			print "$ligne\n";
		}
	}
	print "Aucun\n" if($code == 0);
	return $code;
}

# ---------------------------------------------------------------
# Surveillance des dmons des disques et des volumes.
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	if(VerifCommande("VXDCTL")) {
		$code = traite_demons() + traite_disques()
			+ traite_volumes() + traite_groupes();
	}
	Trace "code=$code" if($debug);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
