#!/serveur/dp/bin/perl -w

# 	$Id: TBO_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance TBO
#
# Surveillance des process TBO pour toutes les instances
# Oracle de la machine.
#
# usage : TBO_sur.pl <nom_template>
#
# Code retour :
#		0 : ok , 1 : erreur, 2 : alarme ITO
#
# exemple : TBO_sur.pl TBO_pro
#
# ---------------------------------------------------------------

use strict;
require("hostname.pl");
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# Vrification des processus pour chaque instance.
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	my @instance = InstanceOracle(hostname());
	Trace "instances : @instance" if($debug);
	my @result = ps("-ef");
	for(@instance) {
		my($instance,$rep,$boot) = split(/:/);
		next if($boot =~ /N/ && !IsCluster());
		print "\nVerification TBO $instance :\n\n";
		my $process = "comp_ora_$instance";
		if(grep(/$process/,@result)==0) {
			print "  processus $process absent\n\n";
			$code = 2;
		} else {
			print "  $instance ok\n\n";
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : process a surveiller
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
