#!/serveur/dp/bin/perl -w

# 	$Id: PROC_pct.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance des process
#
# Indique les process consommant trop de temps CPU.
# Indique s'il y a trop de defunct.
#		
# usage : PROC_pct.pl nom_template
#
# Code retour :
#		0:ok , 1:erreur script, 2:alerte ITO
#
# exemple : PROC_pct.pl PROC_pct
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

my $cpu_time_max = 2500;				# time max pour un process en minutes
my $cpu_time_max_system = 15000;		# time max pour un process system
my $defunct_max = 50;					# max defunct sur la machine
my @process_system = ('nscd','fsflush','ypserv','automountd','Xsun',
					  'SUNWsymon','init\ -','scopeux','netisr',
					  'syslogd','tina_daemon');

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# tout est base sur un ps qui renvoie $uid,$pid,$ppid,$cmd,...
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	my $process_system = join('|',@process_system);
	my @result = ps("-ef");
	print "\nProcessus consommant trop de cpu :\n\n";
	printf("%10s %7s %7s %10s %8s %s\n","UID","PID","PPID","STIME","TIME","CMD");
	for(@result) {
		next if(/^\s*(\S+)\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/UID/);
		next if(/defunct/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd)=($1,$2,$3,$4,$5,$6,$7);
			my($minutes,$secondes) = split(/:/,$time);
			if(($cmd !~ /$process_system/
				&& $minutes+($secondes/60)>$cpu_time_max)
			   || ($minutes+($secondes/60)>$cpu_time_max_system)) {
				printf("%10s %7s %7s %10s %8s %s\n",$uid,$pid,$ppid,$stime,$time,$cmd);
				$code = 2;
			}
		} else {
			print "\nligne non reconnue :\n$_\n";
		}
	}
	my $nb_defunct = 0;
	for(@result) {
		$nb_defunct++ if(/defunct/);
	}
	print "\nDefunct sur le systeme : $nb_defunct\n\n";
	$code = 2 if($nb_defunct>$defunct_max);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
