#!/serveur/dp/bin/perl -w

# 	$Id: FIC_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance de la bonne alimentation d'un fichier en vrifiant
# le mtime du fichier par rapport  un dlai en minutes pass en
# paramtre.
# On vrifie donc que le fichier a bien t modifi depuis ce dlai.
#
# Pour syslog on appelle logger pour confirmer un problme.
# Or logger peut tre trs long, jusqu' 4mn, donc on s'y prend en avance
# ($delai/2) pour viter de devoir faire des sleep pendant ces 4mn.
# Cela veut dire aussi qu'il ne faut pas lancer la template pour la
# syslog avec une priodicit infrieure  8mn.
#
# usage : FIC_sur.pl <nom_template> <fichier> <delai>
#
# Codes retour :
#		0 : ok
#		1 : erreur programme
#		2 : alarme ITO
#
# exemple : FIC_sur.pl SYSLOG_sur /var/adm/messages
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my($fichier,$delai);

# ---------------------------------------------------------------
# Analyse syslog.conf pour trouver un level transmis dans
# le fichier voulu
# le niveau none bloque les messages
# Solstice HA met plein de trucs en ifdef
# ---------------------------------------------------------------
sub level {
	my($fichier) = @_;
	my $retour;
	my @none;
	if(open(CONF,"</etc/syslog.conf")) {
		my @conf = <CONF>;
		close(CONF);
		my $define = 0;
		for(@conf) {
			next if(/^\#/);
			$ENV{$1} = 1 if(/define\((\S+)\)/);
			print "define=$1\n" if(/define\((\S+)\)/ && $debug);
			if(/ifdef\(\`(\S+)\'/) {
				print "ifdef=$1\n" if($debug);
				$define = 1 if(!$ENV{$1});
			}
			$define = 0 if(/\)/);
			next if($define);
			next if(!/\s+$fichier\s*$/);
			print "ligne=$_\n" if($debug);
			my($levels) = split(/\s+/);
			my @level = split(/;/,$levels);
			for(@level) {
				my ($facility,$level) = split(/\./);
				push(@none,$facility) if($level eq 'none');
			}
			print "none=@none\n" if(@none && $debug);
			for(@level) {
				my ($facility,$level) = split(/\./);
				next if($facility eq 'kern');
				$facility = 'daemon' if($facility eq '*');
				next if(@none && grep(/$facility/,@none)>0);
				$retour = "$facility.$level" if(!$retour || $level =~ /^(notice|info|debug)$/);
				print "retour=$retour\n" if($retour && $debug);
			}
		}
	}
	print "retour retenu=$retour\n" if($debug);
	return $retour;
}

# ---------------------------------------------------------------
# Renvoie le nombre de mn depuis le mtime du fichier
# ---------------------------------------------------------------
sub vieux {
	my($fichier) = @_;
	my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat($fichier);
	my $vieux = int((time()-$st_mtime)/60);
	return $vieux;
}

# ---------------------------------------------------------------
# Vrification prsence et mtime
# Pour syslog on appelle logger pour confirmer
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	if(! -f $fichier) {
		print "$fichier absent\n";
		$code = 2;
	} else {
		my $vieux = vieux($fichier);
		if($vieux > $delai/2 && $fichier eq SysLog()) {
			my $level = level($fichier);
			if($level) {
				logger(' -p ',$level,' -- -- MARK -- generated by ITO [$$]');
				for(my $i=0; $i<24 && $vieux>$delai; $i++) {
					sleep 10;			# attente 4mn maxi pour arrive du message
					$vieux = vieux($fichier);
				}
			} else {
				print "Pas de service utilisable pour $fichier dans /etc/syslog.conf\n";
				$code = 2;
			}
		}
		if($vieux > $delai) {
			print("$fichier non modifi depuis $vieux minutes (>$delai)\n");
			$code = 2;
		} else {
			print "$fichier ok\n";
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : fichier et delai
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	my $code = 0;
	if(@ARGV) {
		$fichier = shift(@ARGV);
		if(@ARGV) {
			$delai = shift(@ARGV);
		} else {
			$code = 1;
		}
	} else {
		$code = 1;
	}
	if($code == 1) {
		Trace "Erreur parametres";
	}
	return $code;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
