#!/serveur/dp/bin/perl -w

# 	$Id: DSPstat.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Vrification de Metaphase par dspstat
# - 1 dspstat sur soi
# - 1 dspstat vers chaque host devant tre vu
#
# Serveurs devant se voir :
#
#			 'SCM' => ['SCO','SCP','SCV','SLVR'],
#			 'SCM2' => ['SCO','SCP','SCV','SLP','SLVR'],
#			 'SCP' => ['SCP','SCV','SLP','SLVR'],
#			 'SCT' => ['SCP','SCV'],
#			 'SCV' => ['SCP','SLP','SLVR'],
#			 'SLP' => ['SCP','SCV'],
#			 'SLVR' => ['SCP','SCV'],
#			 tous => <hostname>_network
#
# Comme l'excution est longue, on stocke les rsultats
# dans un fichier log pour consultation ventuelle.
#		
# usage : DSPstat.pl <nom_template> <instance gdg>
#
# Code retour :
#		0 : ok, 2 : alerte ITO
#
# exemple : DSPstat.pl DSPSTAT gdg
#
# ---------------------------------------------------------------

use strict;
require "hostname.pl";
use Fcntl ':flock';
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my $log = "/var/tmp/opc_dspstat.log";
my $user;
my $user_en_ano;
my @instances_a_tester = ('gdg','gdgfor','gdgbis');
chomp(my $hostname = hostname());
my $host_gdg = $hostname;

my %liste = (
			 'SCM' => ['SCO','SCP','SCV','SLVR'],
			 'SCM2' => ['SCO','SCP','SCV','SLP','SLVR'],
			 'SCP' => ['SCP','SCV','SLP','SLVR'],
			 'SCT' => ['SCP','SCV'],
			 'SCV' => ['SCP','SLP','SLVR'],
			 'SLP' => ['SCP','SCV'],
			 'SLVR' => ['SCP','SCV'],
			 );

select(STDERR); $| = 1;     # autoflush
select(STDOUT); $| = 1;     # autoflush

# ---------------------------------------------------------------
# stocke sortie dans fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	print LOG @param;
	print @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# Recherche les instances GDG pour le host
# ---------------------------------------------------------------
sub Instances {
	Trace "Recherche instances" if($debug);
	my @instances;
	foreach my $user (@instances_a_tester) {
		Trace "Teste $user" if($debug);
		my($code,@result) = cfgtest("$user","-d all_servers_gdg");
		my $on_y_est = 0;
		for(@result) {
			$on_y_est = 1 if(/DEFINED NAMES/);
			next if(/DEFINED NAMES|all_servers_gdg|^cfgtest:|not defined/);
			next if($on_y_est==0);
			if(/^\s*(\S+)\s*$/) {
				my $host = $1;
				if($hostname =~ /^(phys-|)$host\d*$/) {
					push(@instances,$user) if(grep(/^$user$/,@instances)==0);
					$host_gdg = $host;
				}
			}
		}
	}
	Trace "Instances=@instances" if($debug);
	return @instances;
}

# ---------------------------------------------------------------
# Fabrique la liste des serveurs devant rpondre au dspstat
# ---------------------------------------------------------------
sub liste_serveurs {
	Trace "Recherche serveurs" if($debug);
	my(%table,@result,$on_y_est,@liste);
	foreach my $liste ('serveurs_centraux','serveurs_locaux') {
		my($code,@temp) = cfgtest("$user","-d $liste");
		$on_y_est = 0;
		for(@temp) {
			$on_y_est = 1 if(/DEFINED NAMES/);
			next if(/DEFINED NAMES|$liste|^cfgtest:|not defined/);
			next if($on_y_est==0);
			if(/^\s*(\S+)\s*$/) {
				my $host = $1;
				$table{$1} = 1;
			}
		}
	}
	foreach my $liste (keys %liste) {
		my($code,@temp) = cfgtest("$user","-d $liste");
		if(grep(/$hostname/,@temp)>0) {
			@liste = @{$liste{$liste}};
			Trace "$hostname dans $liste -> @liste" if($debug);
			last;
		}
	}
	push(@liste,"${hostname}_network");
	foreach my $categ (@liste) {
		Trace "Recherche $categ" if($debug);
		my($code,@temp) = cfgtest("$user","-d $categ");
		$on_y_est = 0;
		for(@temp) {
			$on_y_est = 1 if(/DEFINED NAMES/);
			next if(/DEFINED NAMES|$categ|^cfgtest:|not defined/);
			next if($on_y_est==0);
			if(/^\s*(\S+)\s*$/) {
				my $host = $1;
				if($table{$host} && $table{$host}==1) {
					$table{$host} = 2;
					Trace "ajout $host" if($debug);
				}
			}
		}
	}
	$table{$host_gdg} = 2;
	for(sort keys %table) {
		push(@result,"$_") if($table{$_}==2);
	}
	return @result;
}

# ---------------------------------------------------------------
# dspstat n'a pas de timeout, il faut donc le killer s'il bloque
# les fork+pipe (-|) gardent STDOUT en prise
# launch_perl positionne l'autoflush sur stdout
# ---------------------------------------------------------------
sub dspstat_controle {
	my($remote) = @_;
	my($dspstat_pid,@result,@temp,$control_pid);
	my $code = 0;
	if (!defined($dspstat_pid = open(DSPSTAT,"-|"))) {
		@result = "cannot fork : $!";
		$code = 2;
	} elsif ($dspstat_pid == 0) {		######### I'm the dspstat child
		($code,@result) = dspstat("$user","$remote","-n 10");
		if(@result==1) {
			print "erreur lors du dspstat vers $remote\n";
			$code = 2;
		} else {
			print @result;
		}
		exit $code;
	} else {							######### end dspstat child
		my @ps_label_mem = ps("-p $dspstat_pid -o stime,args");
		if (!defined($control_pid = open(CONTROL,"-|"))) {
			@result = "cannot fork : $!";
			$code = 2;
		} elsif ($control_pid == 0) {	############ I'm the control child
			sleep 180;
			my @ps_label = ps("-p $dspstat_pid -o stime,args");
			if($ps_label_mem[1] && $ps_label[1] && "$ps_label_mem[1]" eq "$ps_label[1]") {
				print "$remote:\n HORS SERVICE\n\n";
				kill(15,$dspstat_pid);
				$code = 2;
			}
			exit $code;
		} else {						######### end control child
			while((my $pid=wait())>0) {
				my $code1 = $?;
				$code = $code1 if($code==0 && $code1!=9);
				kill(9,$control_pid) if($pid==$dspstat_pid);
				kill(9,$dspstat_pid) if($pid==$control_pid);
			}
			@result = (<DSPSTAT>,<CONTROL>);
			close(DSPSTAT);
			close(CONTROL);
		}
	}
	return ($code,@result);
}

# ---------------------------------------------------------------
# On fait un dspstat sur soi-mme et sur les serveurs locaux
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	unlink $log if(-f $log);
	my @instances = Instances();
	for(@instances) {
		$user = $_;
		my $code1 = 0;
		Log("Verification $user\n\n");
		my @remote = liste_serveurs();
		Log("Serveurs verifies :\n@remote\n\n");
		for(@remote) {
			chomp(my $host = $_);
			my($code2,@result) = dspstat_controle($host);
			Log("@result\n");
			for(@result) {
				$code2 = 2 if(/unknown host/);
				$code2 = 2 if(/Dispatcher is not available/);
				$code2 = 2 if(/mux daemon unavailable/);
			}
			$code1 = $code2 if($code2>$code1);
		}
		if($code1!=0) {
			if($user_en_ano) {
				$user_en_ano = "$user_en_ano,$user";
			} else {
				$user_en_ano = "$user";
			}
		}
		$code = $code1 if($code1>$code);
	}
	$user_en_ano = "aucun" if(!$user_en_ano);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	my $code = 0;
	return $code;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO user=$user_en_ano" if($NomTemplate && $debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO -option user=$user_en_ano");
	exit 0;
}

__END__
