#!/serveur/dp/bin/perl -w


# 	$Id: DSK_pct.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Taux d'occupation de l'espace disque
#		
# usage : DSK_pct.pl <nom_template> [mountpoint...]
#		mountpoint : nom du rpertoire de montage d'un volume
#
#		On peut utiliser les caractres gnriques ( la mode perl)
#		pour dcrire le mountpoint.
#		Si plusieurs mountpoints sont demands, on renvoie le plus
#		grand pourcentage d'occupation.
#
# Code retour :
#		xx : pourcentage d'occupation
#
# exemple : DSK_pct.pl DSK_vault_warn /var '/vaults.*' 'auto.work'
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my $test;

# ---------------------------------------------------------------
# tout est base sur un df -k (ou bdf) qui renvoie :
# Filesystem    Type    kbytes    used   avail capacity  Mounted on
# /dev/dsk/c0t3d0s0 ? 1515942 487265 968040 34% / 
# /proc ? 0 0 0 0% /proc 
# fd ? 0 0 0 0% /dev/fd 
# swap ? 545608 688 544920 1% /tmp 
# ...
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $max = 0;
	return 1 if(! VerifCommande("BDF"));
	my @result = bdf();
	for(@result) {
		next if(/^\s*Filesystem/);
		my($filesystem,$type,$size,$used,$avail,$capacity,$mountpoint) = split(/\s+/);
		if($mountpoint =~ /^($test)$/) {
			Trace "$mountpoint $capacity" if($debug);
			$capacity =~ s/%//;
			$max = $capacity if($capacity > $max);
		}
	}
	return $max;
}

# ---------------------------------------------------------------
# lecture des parametres : par groupe de 2, mountpoint et limite
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	while(@ARGV) {
		my $filesystem = shift(@ARGV);
		if($test) {
			$test = "$test\|$filesystem";
		} else {
			$test = "$filesystem";
		}
	}
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
