#!/serveur/dp/bin/perl -w

# 	$Id: DSK_gdg.pl,v 2.1 2000/08/04 08:01:15 legranau Exp $	

# ---------------------------------------------------------------
#
# Contrle le remplissage de l'espace disque vault, work, etc
# pour toutes les instances gdg (production, recette, etc).
#		
# usage : DSK_gdg.pl nom_template
#		map NIS : map contenant les filesystems  vrifier
#
#		Le programme vrifie les volumes de la machine existants
#		dans les maps NIS passes en paramtre.
#
#		vault : plus de 80% d'occupation et moins de 1Go libre
#		work : plus de 80% d'occupation et moins de 1Go libre
#		/BAL : plus de 80% d'occupation et moins de 1Go libre
#		/traitement : plus de 80% d'occupation et moins de 1Go libre
#		/diffusion : plus de 80% d'occupation et moins de 1Go libre
#		/transfert : plus de 80% d'occupation et moins de 1Go libre
#
#		On renvoie le plus grand pourcentage d'occupation.
#
# Code retour :
#		xx : pourcentage d'occupation seulement si les conditions
#				d'alerte sont remplies
#
# exemple : DSK_gdg.pl DSK_gdg
#
# ---------------------------------------------------------------

use strict;
require "hostname.pl";
use File::Basename;
use lib dirname($0);
use dits_def;

my $debug = Debug();

# maps NIS pour les vaults et les works
my @maps = ("vaults.gdg", "auto.work");

# filesystem supplmentaires  vrifier
my @fs = ("/BAL", "/traitement", "/diffusion", "/transfert");
my $filtre = dirname($0) . "/Filtre.pl";

# ---------------------------------------------------------------
# lecture des maps NIS et slection du hostname
# ---------------------------------------------------------------
sub parse_nis {
	my $hostname = hostname();
	$hostname =~ s/^phys-//;
	$hostname =~ s/\d+$//;
	my @filesystems;
	foreach my $map (@maps) {
		my $serveur = ypwhich("-m $map");
		if($serveur =~ /ypwhich/) {
			print "map NIS $map non trouvee\n";
		} else {
			my @lignes = ypcat("-k $map");
			for(@lignes) {
				push(@filesystems,"$1") if(/^\S+\s+$hostname:(\S+)$/);
			}
		}
	}
	return @filesystems;
}

# ---------------------------------------------------------------
# tout est base sur un df -k (ou bdf) qui renvoie :
# Filesystem    Type    kbytes    used   avail capacity  Mounted on
# /dev/dsk/c0t3d0s0 ? 1515942 487265 968040 34% / 
# /proc ? 0 0 0 0% /proc 
# fd ? 0 0 0 0% /dev/fd 
# swap ? 545608 688 544920 1% /tmp 
# ...
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	return 1 if(! VerifCommande("BDF"));
	my $max = 0;
	my @filesystems = parse_nis();
	print "Les filesystem suivant n'ont pas l'espace disponible requis.\n\n";
	printf("%19s %10s %10s %10s %5s %s\n",' ','kbytes','used','avail','capacity','Mounted on');
	foreach my $fs(@filesystems) {
		next if(!-d $fs);
		my @result = bdf($fs);
		for(@result) {
			my($filesystem,$type,$size,$used,$avail,$capacity,$mountpoint) = split(/\s+/);
			next if(/^\s*Filesystem/);
			$capacity =~ s/%//;
			my $texte;
			$texte = '80% max' if($capacity >= 80 && $avail < 1000000);
			$texte = '95% max' if($capacity >= 95 && $avail < 1000000);
			if($texte) {
				Trace "$mountpoint $avail $capacity" if($debug);
				printf("%7s >>> %10d %10d %10d %4d%% %s\n",
					   $texte,$size,$used,$avail,$capacity,$mountpoint);
				system("$filtre 1 $mountpoint");
				my $code = $?;
				$max = $code if($code > $max);
			}
		}
	}
	foreach my $fs (@fs) {
		my $hostname = hostname ();
		next if($hostname =~ /^terence3$/);
		next if(!-d $fs);
		my @result = bdf($fs);
		for(@result) {
			my($filesystem,$type,$size,$used,$avail,$capacity,$mountpoint) = split(/\s+/);
			next if(/^\s*Filesystem/);
			$capacity =~ s/%//;
			my $texte;
			$texte = '80% max' if($capacity >= 80);
			if($texte) {
				Trace "$mountpoint $avail $capacity" if($debug);
				printf("%7s >>> %10d %10d %10d %4d%% %s\n",
					   $texte,$size,$used,$avail,$capacity,$mountpoint);
				system("$filtre 1 $mountpoint");
				my $code = $?;
				$max = $code if($code > $max);
			}
		}
	}
	return $max;
}

# ---------------------------------------------------------------
# lecture des parametres : map NIS
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
