#!/serveur/dp/bin/perl -w

# 	$Id: CRON_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance du bon fonctionnement de cron
#
# usage : CRON_sur.pl nom_template
#
# Code retour :
#		0 : ok , 1 : erreur, 2 : alarme ITO
#
# exemple : CRON_sur.pl CRON_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;
require "ctime.pl";

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = 0;

# ---------------------------------------------------------------
# Vrification du bon fonctionnement de cron et at
# le job at doit mettre une ligne dans le fichier log de cron
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	if(VerifCommande('AT')) {
		my @result;
		my $temp = "/tmp/opc_at.tmp";
		open(TEMP,">$temp");
		print TEMP "echo ok > /dev/null";
		close(TEMP);
		chmod 0755,$temp;
		($code,@result) = at("-f $temp now 2>&1");
		if($code!=0) {
			print "at: code=$code : $!\n@result";
			$code = 2;
		} else {
			sleep 60;
			my $log = CronLog();
			if($log) {
				my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
				   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat($log);
				my $maintenant = time();
				my $vieux = $maintenant - $st_mtime;
				if($vieux>600) {
					print "Le fichier log date de ",ctime($st_mtime);
					print "(il est vieux de $vieux secondes)\n";
					$code = 2;
				}
			}
		}
		unlink $temp;
		if($code == 0) {
			print "Fausse alerte, cron est maintenant ok\n";
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
