#!/serveur/dp/bin/perl -w

# 	$Id: CPU_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance de la CPU utilise
#
# On utilise sar pour obtenir le pourcentage de CPU utilise.
# On tient compte du nombre de processeurs sur la machine.
# En effet si un process tourne  fond sur un bi-processeur, au
# pire il utilisera  fond 1 processeur, donc ~50% de la CPU
# totale de la machine. Or il faut le considrer comme utilisant
# 100% de la CPU et remonter une alerte.
#		
# usage : CPU_sur.pl <nom template>
#
# Code retour : pourcentage de CPU utilise
#
# exemple : CPU_sur.pl CPU_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# pondration pour qu'un % sur plusieurs CPU revienne  95%
# sur 1 seule CPU
# ---------------------------------------------------------------
my %ajustement = (
				  1 => 1,
				  2 => 95/(100+90),
				  3 => 95/(100+75+50),
				  4 => 95/(100+95+75+50),
				  );

# ---------------------------------------------------------------
# tout est base sur un sar
# on pondre selon le nombre de processeurs sur la machine
# on repondre encore car c'est moins grave un proc  100% sur
# un quadripro que sur un mono
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $pct = 0;
	my $nb_proc = NbProc();
	my ($code,@result) = sar("-u 1 2");
	print @result;
	for(@result) {
		next if(!/^Average/);
		my($texte,$usr,$sys,$intr,$wio,$idle) = split;
		$idle = $wio if(!$idle); # sur HP
		$pct = (100 - $idle) * $nb_proc * $ajustement{$nb_proc};
	}
	return $pct;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
