#!/serveur/dp/bin/perl -w

# 	$Id: CPT_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance des comptes utilisateurs
#
# Repre et supprime les rpertoires de compte :
# - qui n'ont pas boug dpuis 6 mois
# - avec comme nom : _dt_index .old .gz .Z toto titi tata
#
# usage : CPT_sur.pl <nom_template>
#
# Code retour :
#		0 : ok , 1 : erreur, 2 : alarme ITO
#
# exemple : CPT_sur.pl CPT_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
require "hostname.pl";
require "ctime.pl";
use lib dirname($0);
use dits_def;
use Fcntl ':flock';

my $log = "/var/tmp/opc_cptsur.log";

my $noms_veroles = '.*(_dt_index|\.old|\.gz|\.Z)|(toto|titi|tata|test)\d*';
my $noms_suspects = '\.(mov|mpg|mpe|mpeg)$';
my $ignore_cpt = 'quotas|lost\+found|TT_DB|ora_.+|oracle_.+';
my $ignore_soft = 'quotas|lost\+found|TT_DB|.*RESERVE.*';
my $aujourdhui = time();
my $vieux = $aujourdhui - 180*24*60*60;
my $semaine_derniere = $aujourdhui - 7*24*60*60;
my $taille_max = 5*1024*1024;		# taille max en octets pour dumpster, etc

my $host = hostname();

my @maps = ("auto.group.$host","auto.logiciel.$host.COMMUN","auto.logiciel.$host.SGISVR4",
			"auto.logiciel.$host.SUNSVR4","auto.bd","auto.bdiao","auto.adm",
			"auto.projet","auto.bdrobcad","auto.bdmt","auto.support","auto.divers");

my(%fait,@repertoires_cpt,%repertoires_cpt,%homedir,%user,
   %email,%people,%bureautique,%host,%dir,
   %auto_map,%repertoires_soft,
   %resultat,%size,%total_sup);

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# stocke sortie dans fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	print LOG @param;
	print @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# fait un tar+compress d'une arborescence avant suppression
# ---------------------------------------------------------------
sub TarCompte {
	my($rep) = @_;
	my $user = basename($rep);
	my($code,@result) = tar("cf $rep.tar $rep/*");
	return $code if($code!=0);
	($code,@result) = compress("$rep.tar");
	return $code;
}

# ---------------------------------------------------------------
# supprime une arborescence
# ---------------------------------------------------------------
sub SupCompte {
	my($rep) = @_;
	return 0; # <<<<<<<<<<<<<<<<<<<<<<<<<<< DESACTIVE <<<<<<<<<<<<<<<<<<<<<<<<<
	my $code = TarCompte($rep);
	return $code if($code!=0);
	$code = 1;
	if(opendir(DIR,$rep)) {
		my @dir = readdir(DIR);
		closedir(DIR);
		for(@dir) {
			next if(/^(\.|\.\.)$/);
			my $file = "$rep/$_";
			if(-f $file) {
				my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
				   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat($file);
				if(! unlink($file)) {
					Log "  $file : erreur unlink : $!\n";
					$code = 0;
				} else {
					$total_sup{dirname($rep)} += $st_size;
				}
			} elsif(-d $file) {
				$code = 0 if(!SupCompte($file));
			}
		}
		if(!rmdir($rep)) {
			Log "  erreur rmdir : $!\n";
			$code = 0;
		}
	} else {
		Log "$rep : erreur opendir : $!\n";
		$code = 0;
	}
	return $code;
}

# ---------------------------------------------------------------
# renvoie le uid d'un fichier ou rpertoire
# ---------------------------------------------------------------
sub uid {
	my($file) = @_;
	my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat($file);
	return $st_uid;
}

# ---------------------------------------------------------------
# indique si le rpertoire est vide hors fichiers et rpertoires
# de configuration (commenant par un '.')
# ---------------------------------------------------------------
sub Vide {
	my($rep) = @_;
	my $vide = 1;
	if(opendir(DIR,$rep)) {
		my @dir = readdir(DIR);
		closedir(DIR);
		for(@dir) {
			next if(/^\./);
			my $file = $_;
			next if(-l "$rep/$file");
			if(-f "$rep/$file") {
				$vide = 0;
				last;
			} elsif(-d "$rep/$file") {
				$vide = Vide("$rep/$file");
				last if($vide==0);
			}
		}
	} else {
		Log "$rep : erreur opendir : $!\n";
	}
	return $vide;
}

# ---------------------------------------------------------------
# renvoie la taille d'une arborescence pour les fichiers
# plus vieux qu'une date limite
# ---------------------------------------------------------------
sub taille {
	my($rep,$vieux) = @_;
	my $size = 0;
	if(opendir(DIR,$rep)) {
		my @dir = readdir(DIR);
		closedir(DIR);
		for(@dir) {
			next if(/^(\.|\.\.)$/);
			my $file = $_;
			Trace "taille $rep/$file" if($debug);
			next if(-l "$rep/$file");
			if(-f "$rep/$file") {
				my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
				   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat("$rep/$file");
				$size += $st_size if($st_size && $st_mtime && $st_mtime<$vieux);
			} elsif(-d "$rep/$file") {
				$size += taille("$rep/$file",$vieux);
			}
		}
	} else {
		Log "$rep : erreur opendir : $!\n";
	}
	return $size;
}

# ---------------------------------------------------------------
# renvoie la taille des fichiers 'suspects'
# ---------------------------------------------------------------
sub taille_suspect2 {
	my($rep) = @_;
	my $size = 0;
	my @files = `find $rep -type f`;
	for(@files) {
		chomp(my $file = $_);
		next if(-l $file);
		next if($file !~ /$noms_suspects/i);
		Trace "taille_suspect $file" if($debug);
		my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
		   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat($file);
		$size += $st_size if($st_size);
	}
	return $size;
}

# ---------------------------------------------------------------
# renvoie la taille des fichiers 'suspects'
# ---------------------------------------------------------------
sub taille_suspect {
	my($rep) = @_;
	my $size = 0;
	if(opendir(DIR,$rep)) {
		my @dir = readdir(DIR);
		closedir(DIR);
		for(@dir) {
			next if(/^(\.|\.\.)$/);
			my $file = $_;
			Trace "taille_suspect $rep/$file" if($debug);
			next if(-l "$rep/$file");
			if(-f "$rep/$file" && $file =~ /$noms_suspects/i) {
				my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
				   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat("$rep/$file");
				$size += $st_size if($st_size);
			} elsif(-d "$rep/$file") {
				$size += taille_suspect("$rep/$file");
			}
		}
	} else {
		Log "$rep : erreur opendir : $!\n";
	}
	return $size;
}

# ---------------------------------------------------------------
# renvoie la date de modification du fichier le plus rcent
# dans une arborescence
# arret si on a une date moins vieille que vieux
# NOTA : la date d'accs est modifie par TINA et n'est donc
# pas exploitable
# NOTA : la date de cration est modifie lors de dplacement de
# compte et n'est donc pas exploitable
# ---------------------------------------------------------------
sub filestat {
	my($rep,$vieux) = @_;
	my ($time,$size) = (0,0);
	my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat($rep);
	$size = $st_size if($st_size);
	$time = $st_mtime if($st_mtime && $st_mtime>$time);
	if($vieux==0 || $time<$vieux) {
		if(opendir(DIR,$rep)) {
			my @dir = readdir(DIR);
			closedir(DIR);
			for(@dir) {
				next if(/^(\.|\.\.)$/);
				my $file = $_;
				next if(-l "$rep/$file");
				Trace "filestat $rep/$file" if($debug);
				if(-f "$rep/$file") {
					($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
					 $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat("$rep/$file");
					$size += $st_size if($st_size);
					$time = $st_mtime if($st_mtime && $st_mtime>$time);
				} elsif(-d "$rep/$file") {
					my ($temp1,$temp2) = filestat("$rep/$file",$vieux);
					$size += $temp1;
					$time = $temp2 if($temp2 && $temp2>$time);
				}
				last if($vieux>0 && $time>$vieux);
			}
		} else {
			Log "$rep : erreur opendir : $!\n";
		}
	}
	return ($size,$time);
}

# ---------------------------------------------------------------
# Vrification des softs
# ---------------------------------------------------------------
sub VerifSoft {
	my($file) = @_;
	Trace "VerifSoft $file" if($debug);
	my @messages;
	my $code = 0;
	my $user = basename($file);
	if(-l $file) {
		push(@messages,"    le rpertoire est un lien\n");
		$code = 2;
	}
	if(!$auto_map{$user}) {
		push(@messages,"    n'est pas dclar dans la map auto.map\n");
		$code = 2;
	}
	if($code>0 && Vide($file)) {
		push(@messages,"    le rpertoire est vide\n");
		$code = 2;
	}
	if($code>0) {
		my($size,$mtime) = (0,0);
		($size,$mtime) = filestat($file,0) if(!-l $file);
		$size{$file} = $size;
		$resultat{$file} = join('    ',@messages);
	}
	if($code>4) {
#		Log "  --> suppression\m";
#		SupCompte($file);
	}
	return $code;
}

# ---------------------------------------------------------------
# Utilise le user associ  l'uid du rpertoire et pas le nom du
# rpertoire directement.
# ---------------------------------------------------------------
sub VerifCompte {
	my($file) = @_;
	Trace "VerifCompte $file" if($debug);
	my $code = 0;
	my @alias_user;
	my @messages;
	my $user = basename($file);
	my $rep = dirname($file);
	my($size,$mtime) = filestat($file,$vieux);
	my $groupe = 0;
	for(@maps) {
		my $map = $_;
		if($host{$map}{$user}) {
			$groupe = 1;
			if($host !~ /^$host{$map}{$user}/) {
				push(@messages,"    devrait tre sur $host{$map}{$user} (cf $map)\n");
				$code = 2;
			} elsif($file ne $dir{$map}{$user}) {
				push(@messages,"    devrait tre en $dir{$map}{$user} (cf $map)\n");
				$code = 2;
			}
		}
	}
	if($groupe==1) {		# on s'arrete l pour group, logiciel, etc
		if($code>0) {
			$size{$file} = $size;
			$resultat{$file} = join('    ',@messages);
		}
		return $code;
	}
	my $uid = uid($file);
	if($fait{$uid}) {
		push(@messages,"    uid $uid dj vu pour $fait{$uid}\n");
		$code = 2;
	} else {
		$fait{$uid} = $file;
	}
	if($rep !~ /disk\d+$/) {
		push(@messages,"    situ sur $rep\n");
		$code = 2;
	}
	if($mtime<$vieux) {
		my ($rien,$mois,$jour,$heure,$type,$an) = split(/\s+/,ctime($mtime));
		my $message = sprintf "    dernire modification le %02d-%s-%d\n",$jour,$mois,$an;
		push(@messages,$message);
		$code = 2;
	} else {
		$size = 0;
		$size += taille("$file/dumpster",$semaine_derniere)
			if(!-l "$file/dumpster" && -d "$file/dumpster");
		$size += taille("$file/Desktop/dumpster",$semaine_derniere)
			if(!-l "$file/Desktop" && !-l "$file/Desktop/dumpster"
			   && -d "$file/Desktop/dumpster");
		$size += taille("$file/.netscape/cache",$semaine_derniere)
			if(!-l "$file/.netscape" && !-l "$file/.netscape/cache"
			   && -d "$file/.netscape/cache");
		my $size_suspect = taille_suspect2($file);
		$size += $size_suspect;
		if($size>$taille_max) {
			if($size_suspect>0) {
				my $mes = sprintf "(%dMo de fichiers X)",$size_suspect/(1024*1024);
				push(@messages,"    caches  nettoyer $mes\n");
			} else {
				push(@messages,"    caches  nettoyer\n");
			}
			$code = 2;
		}
	}
	if($user =~ /^($noms_veroles)$/i) {
		push(@messages,"    n'a pas un beau nom\n");
		$code = 2;
	}
	if(!$user{$uid} || !$homedir{$user{$uid}}) {
		push(@messages,"    n'est pas dclar dans la map passwd\n");
		$code = 2;
	}
	if($user{$uid} && !$email{$user{$uid}}) {
		push(@messages,"    n'est pas dclar dans la map aliases\n");
		$code = 2;
	}
	if($user{$uid} && !$people{$user{$uid}} && !$bureautique{$user{$uid}}) {
		push(@messages,"    n'est pas dclar dans les maps auto.people et auto.bureautique\n");
		$code = 2;
	}
	if($code>0 && Vide($file)) {
		push(@messages,"    le rpertoire est vide\n");
		$code = 2;
	}
	if($code>0) {
		$size{$file} = $size;
		$resultat{$file} = join('    ',@messages);
	}
	if($code>4) {
#		Log "  --> suppression\m";
#		SupCompte($file);
	}
	return $code;
}

# ---------------------------------------------------------------
# Charge les maps NIS
# Les rpertoires des comptes  vrifier sont pris dans auto.people
# ---------------------------------------------------------------
sub ChargeMaps {
	my @result;
	Trace "ChargeMaps" if($debug);
	for(@maps) {
		my $map = $_;
		@result = ypcat("-k $map 2>&1");
		for(@result) {
			next if(/hasn\'t been set/);
			my($user,$hostname,$dir) = split(/\s+|:/);
			$host{$map}{$user} = $hostname;
			$dir{$map}{$user} = $dir;
			Log "$user : situ en $dir ($map)\n"
				if($map =~ /logiciel/ && $host =~ /^$hostname/ && $dir !~ /soft\d+/);
		}
	}
	@result = ypcat("-k auto.datadist 2>&1");
	for(@result) {
		next if(/hasn\'t been set/);
		my($user,$dist,$hostname,$dir) = split(/\s+|:/);
		$host{'auto.datadist'}{$user} = $hostname;
		$dir{'auto.datadist'}{$user} = $dir;
	}
	@result = ypcat("-k aliases 2>&1");
	for(@result) {
		next if(/hasn\'t been set/);
		my($user,$email) = split();
		$email{$user} = $email;
	}
	@result = ypcat("passwd 2>&1");
	for(@result) {
		next if(/hasn\'t been set/);
		my($user,$passwd,$uid,$gid,$info,$homedir,$shell) = split(/:/);
		$homedir{$user} = $homedir;
		$user{$uid} = $user;
	}
	@result = ypcat("-k auto.bureautique 2>&1");
	for(@result) {
		next if(/hasn\'t been set/);
		my($user,$hostname,$dir) = split(/\s+|:/);
		$bureautique{$user} = $dir if($host =~ /^$hostname/);
	}
	@result = ypcat("-k auto.people 2>&1");
	for(@result) {
		next if(/hasn\'t been set/);
		if(/^(\S+)\s+$host:(.+)$/) {
			my($user,$rep) = ($1,$2);
			next if($rep !~ /^\/export\//);
			$people{$user} = $rep;
			$repertoires_cpt{dirname($rep)} = 1;
		}
	}
	@result = ypcat("-k auto.map 2>&1");
	for(sort @result) {
		next if(/hasn\'t been set/);
		my($soft,$type,@suite) = split(/\s+/);
		for(@suite) {
			next if(/^TIVOLI$/);
			my($hosts,$origine,$dir) = split(/:/);
			if(!$hosts || !$dir) {
				Log "$soft : format invalide (auto.map)\n";
			} elsif($origine =~ /$host/) {
				Log "$soft : doublon sur $host (auto.map)\n" if($auto_map{$soft});
				$dir = "/export/home/$dir" if($dir !~ /^\//);
				Log "$soft : $dir inexistant (auto.map)\n" if(! -d $dir);
				if($dir =~ /^(.*soft\d+)/) {
					$dir = $1; # enlve le nom du soft (et version, etc)
					$auto_map{$soft} = $dir;
					$repertoires_soft{$dir} = 1;
				} else {
					Log "$soft : distribu sur $dir (auto.map)\n";
				}
			}
		}
	}
}

# ---------------------------------------------------------------
# Affichage des rsultats
# ---------------------------------------------------------------
sub Resultats {
	my ($texte,$nb_cpt) = @_;
	my %total;
	my $nb = (keys %resultat);
	my $total_possible = 0;
	for(sort { $size{$b} <=> $size{$a} } keys %size) {	# tri sur taille descending
		my $file = $_;
		my $rep = dirname($file);
		my $mes = sprintf "%6dMo  %s\n",$size{$file}/(1024*1024),$file;
		Log $mes;
		$total_possible += $size{$file};
		$total{$rep} += $size{$file};
		$total{$host} += $size{$file};
		Log "    $resultat{$file}\n";
	}
	for(sort keys %total) {
		my $mes = sprintf "\n%-35s %6dMo\n",$_,$total{$_}/(1024*1024);
		Log $mes;
	}
	if($nb_cpt>0) {
		my $mes = sprintf "\n%-35s %d / %d = %d%%\n\n","$texte en anomalie",
		$nb,$nb_cpt,$nb*100/$nb_cpt;
		Log $mes;
	} else {
		$texte =~ s/s$//;
		Log "Aucun $texte trait\n";
	}
	for(sort keys %total_sup) {
		my $mes = sprintf "\nSuppressions %-35s %6dMo\n",$_,$total_sup{$_}/(1024*1024);
		Log $mes;
	}
}

# ---------------------------------------------------------------
# Vrification des comptes, soit dans des rpertoires indiqus
# en paramtre, soit  partir de :
# - la map auto.people (limite au host vrifi)
# - les filesystem disk locaux
# ---------------------------------------------------------------
sub Traitement {
	my($nb_cpt,$code) = (0,0);
	unlink $log if(-f $log);
	Log "\nVrification des maps\n\n";
	ChargeMaps();
	Log "\nVrification des comptes\n\n";
	if(! @repertoires_cpt) {
		my @df = bdf("-lk");
		for(@df) {
			my($filesystem,$type,$size,$used,$avail,$capacity,$mountpoint) = split();
			$repertoires_cpt{$mountpoint} = 1 if($mountpoint =~ /\/disk\d*$/);
		}
		for(keys %repertoires_cpt) {
			push(@repertoires_cpt,$_);
		}
	}
	for(sort @repertoires_cpt) {
		my $rep = $_;
		if(-d $rep && opendir(DIR,$rep)) {
			my @dir = readdir(DIR);
			closedir(DIR);
			for(sort @dir) {
				next if(/^(\.|\.\.)$/);
				next if(/^($ignore_cpt)$/);
				my $file = $_;
				next if(-l "$rep/$file" || ! -d "$rep/$file");
				$nb_cpt++;
				$code = 2 if(VerifCompte("$rep/$file")>0);
			}
		}
	}
	Resultats('comptes',$nb_cpt);
	Log "\nVrification des softs\n\n";
	($nb_cpt,$code) = (0,0);
	undef %total_sup;
	undef %resultat;
	undef %size;
	for(sort keys %repertoires_soft) {
		my $rep = $_;
		if(-d $rep && opendir(DIR,$rep)) {
			my @dir = readdir(DIR);
			closedir(DIR);
			for(sort @dir) {
				next if(/^(\.|\.\.)$/);
				next if(/^($ignore_soft)$/);
				my $file = $_;
				next if(! -d "$rep/$file");
				$nb_cpt++;
				$code = 2 if(VerifSoft("$rep/$file")>0);
			}
		}
	}
	Resultats('softs',$nb_cpt);
	$code = 2; # on force un message mme si tout est ok
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : rpertoires  vrifier
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	@repertoires_cpt = @ARGV if(@ARGV);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
