#!/usr/bin/ksh
#=============================================================================
# Nom		  : verif_ito_agent.ksh
# Cree le	  : 18/06/2001
# Cree par	  : S.GISLAIN
# Objet		  : Verifie le statut de l'agent ITO
# Code retour : 0=OK >0=KO
#=============================================================================
# Modification(s)
#-----------------------------------------------------------------------------
# JJ/MM/AAAA - Auteur
#	Modifications
# 14/08/2001 - S.GISLAIN
#	Ajout verif perl TCR
#=============================================================================
# Debuggage
#
#typeset DEBUG="set -x"
typeset DEBUG=""
${DEBUG}

PROG=$(/usr/bin/which ${0})
DIR=$(/usr/bin/dirname $PROG)
CHEMIN=$(cd $DIR; /usr/bin/pwd)

#=============================================================================
# Chargement librairie ITO
#
typeset OS=$( uname -s )

[[ ${OS} = 'HP-UX' ]] && typeset REP_LIB=/var/opt/OV/bin/OpC/cmds
[[ ${OS} = 'SunOS' ]] && typeset REP_LIB=/var/opt/OV/bin/OpC/cmds
[[ ${OS} = 'Aix'   ]] && typeset REP_LIB=/usr/OV/bin/OpC/cmds
[[ ${OS} = 'IRIX'  ]] && typeset REP_LIB=/usr/OV/bin/OpC/cmds

REP_LIB="."

if [[ ! -f ${REP_LIB}/librenault ]]
then
	if [[ ! -f ${CHEMIN}/librenault ]]
	then
		print "Librairie de fonctions '${REP_LIB}/librenault' absente !"
		exit 1
	else
		REP_LIB=${CHEMIN}
	fi
fi

. ${REP_LIB}/librenault

typeset OPCAGT="$(dirname ${OPCMON})/opcagt"

#=============================================================================
# Code de retour
#
typeset -i RESULT=0		# 0=OK / 1=KO / 2=LOCK
typeset -i ETAPE=0		# Numero de l'etape
typeset PB=""			# Liste des etapes a pb

#=============================================================================
# Processus de l'agent
#
function ProcessusAgent {
	${DEBUG}

	typeset LRESULT=0
	typeset -i Status=0
	let ETAPE=ETAPE+1

	typeset ListeProcessus="opcctla -start|opcmsga|opcacta|opcle|opcmona|opcmsgi"
	typeset -i NbProc=0
	typeset -i Nb=1

	print "${ETAPE}. Recherche des processus : \c"

	[[ $(${CommandePs} | grep -c "[o]vspmd") -gt 0 ]] && ListeProcessus="${ListeProcessus}|opctrapi"

	typeset NbProcAttendus=$(print ${ListeProcessus} | ${CommandeAwk} -F"|" 'END { print NF }')

	print ${ListeProcessus} | ${CommandeAwk} -v Sep="|" '
{
	Chaine = $0;
	while( index( Chaine, Sep ) != 0 ) {
		Pos = index( Chaine, Sep );
		Champ = substr( Chaine, 1, Pos - 1 );
		Chaine = substr( Chaine, Pos + length( Sep ), length( Chaine ) - Pos );
		print Champ;
	}
	print Chaine;

}' | while read Proc
	do
		[[ $( ${CommandePs} | egrep "${Proc}" | grep -cv grep ) -ne 1 ]] && LRESULT=1
	done

	if [[ ${LRESULT} -ne 0 ]]
	then
		print "KO <<<<<<<<<<<<<<<<<<<<"

		print ${ListeProcessus} | ${CommandeAwk} -v Sep="|" '
{
	Chaine = $0;
	while( index( Chaine, Sep ) != 0 ) {
		Pos = index( Chaine, Sep );
		Champ = substr( Chaine, 1, Pos - 1 );
		Chaine = substr( Chaine, Pos + length( Sep ), length( Chaine ) - Pos );
		print Champ;
	}
	print Chaine;

}' | while read Proc
		do
			print "    ${Nb}. '${Proc}' \c"

			${CommandePs} |
				grep "${Proc}" |
				grep -v grep |
				${CommandeAwk} '
END {
	if( NR == 0 )
		print "absent : KO <<<<<<<<<<<<<<<<<<<<";
	if( NR == 1 )
		print ": OK";
	if( NR > 1 )
		print NR " processus : KO <<<<<<<<<<<<<<<<<<<<";
}'
			
			let Nb=Nb+1
		done

		NbProc=$( ${CommandePs} |  egrep "${ListeProcessus}" | grep -vc grep )

		print "\n    ${NbProcAttendus} processus attendus / ${NbProc} processus trouve(s)"
	else
		print "OK"
	fi
	
	print ""

	[[ ${LRESULT} -ne 0 ]] && PB="${PB} ${ETAPE}"

	let RESULT=RESULT+LRESULT
}

#=============================================================================
# Status de l'agent
#
function StatusAgent {
	${DEBUG}
	typeset LRESULT=0
	let ETAPE=ETAPE+1

	print "${ETAPE}. Status de l'agent : \c"

	if [[ ${QUISUIJE} != "root" ]]
	then
		print "KO <<<<<<<<<<<<<<<<<<<<"
		print "    Cette etape doit etre executee en root !"
		LRESULT=1
	else
		typeset Flag="OK"
		typeset Lignes="    "

		${OPCAGT} -status 2>&1 | while read Ligne
		do
			Lignes="${Lignes}\n    ${Ligne}"

			[[ $(print ${Ligne} | egrep -c "isn't running|not running") -gt 0 ]] && Flag="KO"
		done

		if [[ ${Flag} = "KO" ]]
		then
			print "KO <<<<<<<<<<<<<<<<<<<<\n${Lignes}"
			LRESULT=1
		else
			print "OK"
		fi
	fi

	print ""

	[[ ${LRESULT} -ne 0 ]] && PB="${PB} ${ETAPE}"

	let RESULT=RESULT+LRESULT
}

#=============================================================================
# Contact reseau du manager
#
function Ping {
	${DEBUG}
	typeset Serv=$1
	typeset FicTemp="${OPCTMP}/ping.out"
	typeset Retour=0

	cat /dev/null > ${FicTemp}
	chmod 777 ${FicTemp}

	case ${TypeMachine} in
		HP-UX)	ping ${Serv} 64 2
				;;
		SunOS|Aix|IRIX|Linux)
				ping -s ${Serv} 64 2
				;;
	esac > ${FicTemp} 2>&1

	Status=$?
	[[ ${Status} -ne 0 ]] && Retour=${Status}

	[[ $(wc -l ${FicTemp} | awk '{print $1}') -lt 15 ]] && Retour=1

	rm -f ${FicTemp}
}

#=============================================================================
# Verification config de l'agent
#
function ConfigAgent {
	${DEBUG}
	typeset LRESULT=0
	let ETAPE=ETAPE+1

	print "${ETAPE}. Configuration de l'agent : \c"

	typeset Nodeinfo=${OPCCONF}/nodeinfo

	typeset Controlled=$(${CommandeAwk} -F" " '/^OPC_NODE_TYPE/ { print $2 }' ${Nodeinfo})
	typeset IPAgent=$(${CommandeAwk} -F" " '/^OPC_IP_ADDRESS/ { print $2 }' ${Nodeinfo})
	typeset Logdir=$(${CommandeAwk} -F" " '/^OPC_AGENT_LOG_DIR/ { print $2 }' ${Nodeinfo})

	if [[ ${Controlled} != "CONTROLLED" ]]
	then
		print "KO <<<<<<<<<<<<<<<<<<<<"

		print "    Agent non controle !"
		LRESULT=1
	fi

	typeset Serveur=$(uname -n)
	typeset IP=$( nslookup ${Serveur} | ${CommandeAwk} '
BEGIN { nb=0 }
{
	if( /^Using \/etc\/hosts/ )
		nb++;

	if( /^Address:/ ) {
		nb++

		if( nb >= 2 )
			print $2;
	}
} ')

	if [[ ${IPAgent} != ${IP} ]]
	then
		[[ ${LRESULT} -ne 1 ]] && print "KO <<<<<<<<<<<<<<<<<<<<"
		print "    Adresse IP '${IP}' differente adresse IP declaree dans ITO '${IPAgent}' !"
		LRESULT=1
	fi

	if [[ ! -d ${Logdir} ]]
	then
		[[ ${LRESULT} -ne 1 ]] && print "KO <<<<<<<<<<<<<<<<<<<<"
		print "    Repertoire du fichier de log '${Logdir}' inexistant !"
		LRESULT=1
	fi

	typeset Opcinfo=${OPCINST}/opcinfo
	typeset Manager=$(${CommandeAwk} -F" " '/^OPC_MGMT_SERVER/ { print $2 }' ${Opcinfo})

	Ping ${Manager}

	if [[ $? -ne 0 ]]
	then
		[[ ${LRESULT} -ne 1 ]] && print "KO <<<<<<<<<<<<<<<<<<<<"
		print "    Erreur(s) lors du contact du '${Manager} par ping !"
		LRESULT=1
	fi

	[[ ${LRESULT} -eq 0 ]] && print "OK"

	[[ ! -r ${OPCTEMPL}/cmds/${Serveur} ]] && print "    Fichier de configuration '${OPCTEMPL}/cmds/${Serveur}' absent."

	print ""

	[[ ${LRESULT} -ne 0 ]] && PB="${PB} ${ETAPE}"

	let RESULT=RESULT+LRESULT
}

#=============================================================================
# Verifie la couche de communication
#
function CommunicationAgent {
	${DEBUG}
	typeset LRESULT=0
	let ETAPE=ETAPE+1

	typeset FicTemp="${OPCTMP}/lb_admin.out"
	cat /dev/null > ${FicTemp}
	chmod 777 ${FicTemp}

	typeset Flag="OK"

	print "${ETAPE}. Status de la couche de communication : \c"

	case ${TypeMachine} in
	HP-UX)	Proc="/opt/dce/sbin/rpcd|/opt/dce/sbin/dced"
			;;

	SunOS)	Proc="/opt/ncs/bin/llbd"

			print "l\nq" | /opt/ncs/bin/lb_admin > ${FicTemp} 2>&1

			if [[ $(grep "Control Agent (COA" ${FicTemp} | grep -c "`uname -n`") -ne 2 ]]
			then
				Flag="KO"
			fi

			;;

	Aix)	Proc="?"
			;;

	IRIX)	Proc="/opt/ncs/bin/llbd"
			;;

	Linux)	Proc="?"
			;;
	esac

	if [[ $(${CommandePs} | egrep "${Proc}" | grep -cv grep) -ne 1 ]]
	then
		print "KO <<<<<<<<<<<<<<<<<<<<"
		print "    Processus '${Proc}' absent !"
		LRESULT=1
	fi

	if [[ ${Flag} = "KO" ]]
	then
		[[ ${LRESULT} -ne 1 ]] && print "KO <<<<<<<<<<<<<<<<<<<<"
		print "    Connexions absentes !"
		LRESULT=1
	fi

	[[ ${LRESULT} -eq 0 ]] && print "OK"

	print ""

	rm -f ${FicTemp}

	[[ ${LRESULT} -ne 0 ]] && PB="${PB} ${ETAPE}"

	let RESULT=RESULT+LRESULT
}

#=============================================================================
# Verifie les files d'attente
#
function QueuesAgent {
	${DEBUG}
	typeset LRESULT=0
	let ETAPE=ETAPE+1

	typeset -i TailleO=300*1024

	print "${ETAPE}. File d'attentes : \c"

	ls -l ${OPCTMP}/*q |
	${CommandeAwk_v} TailleO=${TailleO} ' $5 >= TailleO { print $5 " " $9 }' |
	while read Taille Queue
	do
		#if [[ ${LRESULT} -eq 0 ]]
		#then
			print "KO <<<<<<<<<<<<<<<<<<<<"
			LRESULT=1
		#fi

		print "    ${Queue} ${Taille} Ko > a ${TailleO} Ko" !
	done

	[[ ${LRESULT} -eq 0 ]] && print "OK"

	print ""

	[[ ${LRESULT} -ne 0 ]] && PB="${PB} ${ETAPE}"

	let RESULT=RESULT+LRESULT
}

#=============================================================================
# Verifie la presence de perl
#
function PresencePerl {
	${DEBUG}
	typeset LRESULT=0
#	typeset PP_PERL="/serveur/dp/bin/perl"
	let ETAPE=ETAPE+1

	print "${ETAPE}. Presence de perl : \c"
	
	if [[ -d $(${BASENAME} ${PP_PERL}) ]]
	then
		if [[ ! -x ${PP_PERL} ]]
		then
			print "KO <<<<<<<<<<<<<<<<<<<<"
			
			print "	Perl n'est pas installe correctement !"
			LRESULT=1
		else		
			typeset PP_VERSION=$(${PP_PERL} -V | grep subversion | awk '{ print $5 $7 $9 }')
			
			if [[ ${PP_VERSION} != "(5.052)" ]]
			then
				print "KO <<<<<<<<<<<<<<<<<<<<"
				print "	Version installee ${PP_VERSION} invalide !"
				LRESULT=1
			fi
		fi
	fi

	[[ ${LRESULT} -eq 0 ]] && print "OK"

	if [[ ! -d $(${BASENAME} ${PP_PERL}) ]]
	then
		print "	Ce n'est pas un serveur ou Perl est necessaire."
	fi
	
	print ""

	[[ ${LRESULT} -ne 0 ]] && PB="${PB} ${ETAPE}"

	let RESULT=RESULT+LRESULT
}

#=============================================================================
# Verifie si une distribution est en attente
#
function DistribAgent {
	${DEBUG}
	typeset LRESULT=0
	let ETAPE=ETAPE+1

	print "${ETAPE}. Distribution en cours \c"

	if [[ $(${CommandePs} | grep "opcctla -config" | grep -cv grep) -eq 1 ]]
	then
		print "OUI : KO <<<<<<<<<<<<<<<<<<<<"
		LRESULT=1
	else
		print "NON : OK"
	fi

	print ""

	[[ ${LRESULT} -ne 0 ]] && PB="${PB} ${ETAPE}"

	let RESULT=RESULT+LRESULT
}

#=============================================================================
# Verifie si des templates sont bloques
#
function TemplatesBloques {
	${DEBUG}
	typeset LRESULT=0
	let ETAPE=ETAPE+1

	print "${ETAPE}. Processus de templates \c"

	typeset Pids=$( ${CommandePs} | ${CommandeAwk} ' ! /grep/ && /OpC/ && ! /opcctla/ { print $2 }' )
	typeset Nb=$( print ${Pids} | ${CommandeAwk} 'END { print NF }' )

	if [[ ${Nb} -ne 0 ]]
	then
		print "${Nb} present$( [[ ${Nb} -gt 1 ]] && print "s\c" ) : OK"

		for Pid in ${Pids}
		do
			${CommandePsPid} ${Pid} | ${CommandeAwk} 'NR > 1 { print "    " $0 }'
		done

	else
		print "aucun : OK"
	fi

	print ""
}

#=============================================================================
# Procedure principale
#
typeset QUISUISJE=$( id | ${CommandeAwk} '
{
	pos1 = index( $0, "(" );
	pos2 = index( $0, ")" );
	print substr( $0, pos1 + 1, pos2 - pos1 - 1 );
}' )

print "#============================================================================="
print " $0 [ $(ls -l $0 | ${CommandeAwk} '{ print $6 " " $7 " " $8 " - " $5 " Ko"}') - ${QUISUISJE}($$) ]"
print " $(date)"

print "#-----------------------------------------------------------------------------\n"

if [[ ${QUISUISJE} != "root" ]]
then
	print ">>> Attention certaines etapes necessitent d'etre connecte en root."
	print ">>> La verification ne pourra pas etre complete.\n"
fi

ConfigAgent

ProcessusAgent
 
StatusAgent

CommunicationAgent

QueuesAgent

DistribAgent

TemplatesBloques

PresencePerl

print "#-----------------------------------------------------------------------------\n"

case ${RESULT} in
	0)	banner OK
		;;

	*)	banner KO

		case $(print ${PB} | ${CommandeAwk} 'END { print NF }') in
			0)	;;
			1)	print "Probleme(s) lors de l'etape : ${PB}."
				;;
			*)	print "Probleme(s) lors des etapes : ${PB}."
				;;
		esac

		print "\nMerci de contacter le support ITO.\n"
		;;
esac

print "#-----------------------------------------------------------------------------"
print " $(date)"
print "#============================================================================="

print "RC=${RESULT}"
exit ${RESULT}

# eof --------------------------------------------------------
