#!/serveur/dp/bin/perl -w
#-*- Perl -*-

# 	$Id: scan_disk.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------------------------
#
# Recherche des rpertoires les plus chargs pour un mountpoint donn
# On ne prend que les rpertoires et fichiers du device correspondant
# au mountpoint.
#
# usage : scan_disk.pl <mountpoint>
#
# exemple : scan_disk.pl /var
#
# ---------------------------------------------------------------------------------

use strict;

# ---------------------------------------------------------------------------------
#
# Performances : c'est sr a utilise de la CPU...
#
# itotcr root> time du -k /
# 1.0u 17.3s 1:43 17%
# itotcr root> time find / -xdev -type d -print
# 1.4u 12.5s 0:57 24%
# itotcr root> time /home/de/verdiemi/proito/scan_disk.pl /
# 12.7u 44.2s 2:46 34%
# ---------------------------------------------------------------------------------

my $nb_max = 50;		# nb de fichiers/rpertoires lists
my $size_max = 10;		# taille seuil en Ko
my $usage = "usage : $0 <mountpoint> [-n <nb>] [-s <taille>]\n";
my $mountpoint;
my %size;

# ---------------------------------------------------------------------------------
# vrification d'un rpertoire
# ---------------------------------------------------------------------------------
sub scan_rep {
	my($rep,$device) = @_;
	my $size = 0;
	my($st_dev,$rien,$rien,$rien,$rien,$rien,$rien,$st_size) = stat($rep);
	next if($st_dev!=$device);
	opendir(DIR,$rep);
	my @dir = readdir(DIR);
	close(DIR);
	for(@dir) {
		next if(/(\.|\.\.)$/);
		my $file = "$rep/$_";
		$file =~ s/^\/\//\//;
		next if(-d $file || -l $file || -p $file || -S $file || -b $file || -c $file || -t $file);
		my($st_dev,$rien,$rien,$rien,$rien,$rien,$rien,$st_size) = stat($file);
		next if($st_dev!=$device);
		$size{">> $file"} = $st_size if($st_size>$size_max);
		$size = $size + $st_size;
	}
	$size{"   $rep"} = $size if($size>$size_max);
}

while(@ARGV) {
	my $param = shift(@ARGV);
	if($param eq '-n') {
		$nb_max = shift(@ARGV) || die $usage;
	} elsif($param eq '-s') {
		$size_max = shift(@ARGV) || die $usage;
	} elsif($param eq '-h') {
		die $usage;
	} else {
		$mountpoint = $param;
	}
}
die $usage if(!$mountpoint);
die "parametre $mountpoint invalide\n" if(! -d $mountpoint);
my($device) = stat($mountpoint);

print "parsing directory $mountpoint for $nb_max files of more than ${size_max}Mo, please wait\n";
$size_max = $size_max * 1024 * 1024;

my @dir = `find $mountpoint -xdev -type d -print 2> /dev/null`;
@dir = `find $mountpoint -type d -print 2> /dev/null` if($? != 0);
for(@dir) {
	chomp(my $dir = $_);
	scan_rep($dir,$device);
}

my $nb = 0;
for(sort { $size{$b} <=> $size{$a} } keys %size) {	# tri descendant sur size
	next if(!$size{$_});
	printf "%10d  %s\n",$size{$_}/1024,$_;
	last if($nb++>$nb_max);
}

exit 0;

__END__
