package opc;

# 	$Id: opc.pm,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# -----------------------------------------------------------------------
#
# Description:
#
#		Fonctions pour OpC / ITO
#
# usage:
#
#	use opc;
#
# -----------------------------------------------------------------------

require 5.004;
use strict;
use File::Basename;
use lib dirname($0);
use dits_def;
use File::Copy;
use Fcntl ':flock';

#
# NE PAS FAIRE DE REQUIRE HOSTNAME.PL
#

require Exporter;
use vars qw(@ISA @EXPORT $VERSION);
@ISA = qw(Exporter);
$VERSION = "1.0";

@EXPORT = qw(arret_ito demarrage_ito nettoie_log nettoie);

my $sid;
if($ENV{'ORACLE_SID'}) {
	$sid = "oracle" . $ENV{'ORACLE_SID'};
} else {
	$sid = "oracleitotcr|oracleitoctr";
}

# --------------------------------------------------------------------------------
# nettoyage du fichier log
# --------------------------------------------------------------------------------
sub nettoie_log {
	my $log = OpcLog() . "/opc.log";
	if(-f $log) {
		my($dev,$ino,$mode,$nlink,$uid,$gid,$rdev,$size,
		   $atime,$mtime,$ctime,$blksize,$blocks) = stat($log);
		if($size>1000000 && open(LOG,"<$log") && flock(LOG,LOCK_EX)) {
			unlink("$log.0") if(-f "$log.0");
			copy($log,"$log.0");
			if(open(CLEANLOG,">$log")) {
				close(CLEANLOG);
			}
			flock(LOG,LOCK_UN);
			close(LOG);
		}
	}
}

# --------------------------------------------------------------------------------
# nettoyage d'un rpertoire
# --------------------------------------------------------------------------------
sub nettoie {
	my ($rep) = @_;
	Trace "nettoyage $rep" if(Debug());
	opendir(DIR,"$rep");
	my @files = readdir(DIR);
	close(DIR);
	for(@files) {
		next if(/^(\.|\.\.)$/);
		my $file = "$rep/$_";
		if(-d $file) {
			nettoie($file);
			rmdir $file;
		} else {
			unlink $file;
		}
	}
}

# --------------------------------------------------------------------------------
# attente avec petite animation pour ceux qui surveillent...
# il faut donc enlever le buffering de STDOUT
# --------------------------------------------------------------------------------
sub waiting {
	my $tempo = shift(@_);
	my $old = $|;
	select(STDOUT); $| = 1;
	Trace "Attente des process" if(Debug());
	my $i=0;
	for($i=0;$i<10;$i++) {
		sleep $tempo/10;
	}
	select(STDOUT); $| = $old;
}

# --------------------------------------------------------------------------------
# arrt des sessions users, arrt agent ITO, arrt serveur
# avec un paramtre 1, on arrete aussi les users
# avec un paramtre 2, on arrete aussi Oracle
# Pour la base Oracle il faut y aller doucement : pas de kill -9, seulement
# des kill -15. Il vaut mieux faire un shutdown que de redmarrer sur une
# base instable.
# --------------------------------------------------------------------------------
sub arret_ito {
	my $soft = shift(@_) || 0;
	my $ok = 0;
	my($code,@result);
	my $wait = 0;
 	my @process = ps("-e");
	for(@process) {
		next if(/PID/);
		my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
		next if(!$pid || $pid == $$);
		if($name =~ /^opcctla/) {
			Trace "Arret agents : opcagt -kill" if(Debug());
			($code,@result) = opcagt("-kill");
			Trace "@result\ncode=$code" if(Debug());
			$wait = 1;
		}
	}
	for(@process) {
		next if(/PID/);
		my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
		next if(!$pid || $pid == $$);
		if($name =~ /^opcctlm/) {
			Trace "Arret serveur : ovstop" if(Debug());
			($code,@result) = ovstop("-d -v");
			Trace "@result\ncode=$code" if(Debug());
			$wait = 1;
		}
	}
	if($soft>0) {
		for(@process) {
			next if(/PID/);
			my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
			next if(!$pid || $pid == $$);
			if($name =~ /^ovw$/) {
				Trace "Arret users : kill -15 $pid" if(Debug());
				kill 15, $pid;
				$wait = 1;
			}
		}
	}
	@process = ps("-e");
	for(@process) {
		next if(/PID/);
		my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
		next if(!$pid || $pid == $$);
		if($name =~ /^opcctla/) {
			Trace "Arret agents : opcctla -kill" if(Debug());
			($code,@result) = opcctla("-kill");
			Trace "@result\ncode=$code" if(Debug());
			$wait = 1;
		}
	}
	for(@process) {
		next if(/PID/);
		my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
		next if(!$pid || $pid == $$);
		if($name =~ /^opc/) {
			Trace "Arret serveur : ovstop" if(Debug());
			($code,@result) = ovstop("-d -v");
			Trace "@result\ncode=$code" if(Debug());
			$wait = 1;
		}
	}
	waiting(10) if($wait);
	$wait = 0;
	@process = ps("-e");
	for(@process) {
		next if(/PID/);
		my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
		next if(!$pid || $pid == $$);
		if($name =~ /^opc/) {
			Trace "Arret serveur et agents : kill -9 $pid" if(Debug());
			kill 9, $pid;
			$wait = 1;
		}
	}
	if($soft>0) {
		for(@process) {
			next if(/PID/);
			my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
			next if(!$pid || $pid == $$);
			if($name =~ /^ovw|^ipmap|^ovhelp/) {
				Trace "Arret users : kill -9 $pid" if(Debug());
				kill 9, $pid ;
				$wait = 1;
			}
		}
		waiting(20) if($wait);
		$wait = 0;
	}
	waiting(30) if($wait);
	$wait = 0;
	if($soft>0) {
		@process = ps("-ef");
		for(@process) {
			next if(/PID/);
			my($pid,$reste) = ($1,$2) if(/\s*\S+\s+(\d+)\s+(.+)$/);
			next if(!$pid || $pid == $$);
			if($reste =~ /($sid)/) {
				Trace "Arret Oracle $sid : kill -15 $pid" if(Debug());
				kill 15, $pid ;
				$wait = 1;
			}
		}
		waiting(10) if($wait);
		$wait = 0;
	}
	if($soft>1) {
		Trace "Arret Oracle : ovoracle stop" if(Debug());
		($code,@result) = ovoracle("stop");
		Trace "@result\ncode=$code" if(Debug());
		waiting(10);
	}
	@process = ps("-e");
	for(@process) {
		next if(/PID/);
		my($pid,$name) = ($1,$2) if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
		next if(!$pid || $pid == $$);
		$ok = 1 if($soft>1 && $name =~ /^oracle|^tnslsnr/);
		$ok = 1 if($soft>0 && $name =~ /^ovw|^ipmap$|^ovhelp$/);
		$ok = 1 if($name =~ /^opc/);
	}
# normalement le opcagt -kill nettoie tout a
#	nettoie("/var/opt/OV/tmp/OpC");
	return $ok;
}

# --------------------------------------------------------------------------------
# dmarrage complet ITO : Oracle + serveur + agent
# --------------------------------------------------------------------------------
sub demarrage_ito {
	my $soft = shift(@_) || 0;
	my($code,@result);
	my %pid;
	my $ok = 1;
	my @process = ps("-e");
	for(@process) {
		$pid{$2} = $1 if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
	}
	if(-d "/var/opt/OV/log/OpC/mgmt_sv") {
		if(! $pid{"oracle"}) {
			Trace "Demarrage Oracle : ovoracle start" if(Debug());
			($code,@result) = ovoracle("start");
			Trace "@result\ncode=$code" if(Debug());
			waiting(20);
		}
		if(! $pid{"opcctlm"}) {
			Trace "Demarrage serveur : ovstart" if(Debug());
			($code,@result) = ovstart("-d -v");
			Trace "@result\ncode=$code" if(Debug());
			waiting(10);
		}
	}
	if(! $pid{"opcctla"}) {
		Trace "Demarrage agents : opcagt -start" if(Debug());
		($code,@result) = opcagt("-start");
		Trace "@result\ncode=$code" if(Debug());
		waiting(10);
	}
	undef %pid;
	@process = ps("-e");
	for(@process) {
		$pid{$2} = $1 if(/\s*(\d+)\s+\S+\s+\S+\s+(\S+)/);
	}
	if(-d "/var/opt/OV/log/OpC/mgmt_sv") {
		$ok = 0 if($pid{"oracle"} && $pid{"opcctlm"} && $pid{"opcctla"});
	} else {
		$ok = 0 if($pid{"opcctla"});
	}
	return $ok;
}

1;

__END__
