#!/serveur/dp/bin/perl -w

# -------------------------------------------------------------------------
# Lancement direct d'une commande systme
#		
# usage : lance.pl nom_template commande [parametres]
#		commande : commande dfinie dans dits_def.pm
#		parametres : paramtres pour la commande
#
# Code retour :
#		0 : ok, 2 : alarme ITO
#
# exemple : lance.pl PROC_sur opcagt -start
#
# -------------------------------------------------------------------------

# pas de 'use strict' pour les rfrences de fonction
# use strict;

use File::Basename;
use lib dirname($0);
use dits_def;

my $debug = Debug();

Trace @ARGV if($debug);

my $code = 1;

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate = shift(@ARGV) if(@ARGV);
my $commande = shift(@ARGV) if(@ARGV);
my @param = @ARGV if(@ARGV);

if($commande) {
	Trace "lancement commande=$commande @param" if($debug);
	my @result = &$commande("@param");
	$code = $?;
	print @result;
	Trace "code=$code result=@result" if($debug);
} else {
	Trace "Erreur parametrage";
}

# envoi du code retour a ITO via opcmon
Trace "$NomTemplate=$code" if($debug);
#opcmon("$NomTemplate=$code");

# envoi du code retour en direct
exit $code;

__END__
