#!/usr/bin/sh
# OPC_WHAT_STRING="@(#)HP OpenView IT/Operations A.04.12 (01/08/99)"
###############################################################################
#
# File:         mailq_pr.sh
# Description:  Print the sendmail mail queue (HP-UX, AIX, SunOS, Solaris, NCR,IRIX)
# Language:     Bourne Shell
# Package:      HP OpenView OperationsCenter
###############################################################################
PROGNAME=`basename ${0}`

# print_msg() updates EXIT_CODE automatically using
# this utility function for script exit value.
# it keeps the worst exit code in ${EXIT_CODE}
#--------------------------------------------------
SUCCESS=0
FAILURE=1
WARNING=2

EXIT_CODE=${SUCCESS}

eval_exit()
{
  exit_new=$1

  if [ ${exit_new} -eq ${FAILURE} ]
  then
    EXIT_CODE=${FAILURE}
  elif [ ${exit_new} -eq ${WARNING} -a ${EXIT_CODE} -eq ${SUCCESS} ]
  then
    EXIT_CODE=${WARNING}
  fi

  return 0
}

#-------------------------------
#
# print_msg: print message to stderr/stdout and optional to logfile
#
#-------------------------------
# usage: print_msg <mode> <messages> ...
#
# <mode>: ( <type> | <fd> | <type><fd> | "." )
#
#        <type>:     use this type with <fd> = 2
#        <fd>:       use this fd with <type> = I
#        <type><fd>: use type and fd
#        ".":        use empty prefix and fd of last call
#
# <type>: ( "I" | "E" | "W" | "N" | "U" )
#          defines message prefix:
#          I)nfo:    "         "
#          E)rror:   "ERROR:   "
#          W)arning: "WARNING: "
#          N)ote:    "NOTE:    "
#          U)sage:   "USAGE:   "
#
# <fd>: file descriptor for output (2 = stderr, 1 = stdout)
#
# <messages>: the first message argument will be printed with
#             the selected prefix. Optionally following message
#             arguments will be printed in seperate lines with
#             an empty prefix.
# 
#-------------------------------
# examples:
#
# 1.) print_msg W "Something went wrong"
#
#     output to stderr: WARNING: Something went wrong
#
# 2.) print_msg N1 "Be aware that"
#     print_msg .  "something has happened"
#
#     output to stdout: NOTE:    Be aware that
#                     :          something has happened
#
# 3.) print_msg E2 "this is" "an" "error"
#
#     output to stderr: ERROR:   this is
#                     :          an
#                     :          error
#
#-------------------------------
# logging:
#
# default: logging is disabled
# enable logging with:  enable_logging <logfile>
# disable logging with: disable_logging
#
# if logging is enabled, all output of print_msg
# is also printed into the specified logfile.
#    
#--------------------------------
# exit codes:
#
# print_msg calls the shlib_misc:eval_exit() function
# with an appropriate parameter 
# in order to keep the EXIT_CODE up to date
#
#--------------------------------
MSG_LOGFILE=""

MSG_INFO="I"
MSG_ERROR="E"
MSG_WARN="W"
MSG_NOTE="N"
MSG_USAGE="U"
MSG_QUERY="Q"
MSG_LOG="L"    # goes to log only if enabled
MSG_SAME="."

#
# prefixes must have length 9
#                 123456789
      MSG_PREFIX="         "
 MSG_PREFIX_INFO="         "
MSG_PREFIX_ERROR="ERROR:   "
 MSG_PREFIX_WARN="WARNING: "
 MSG_PREFIX_NOTE="NOTE:    "
MSG_PREFIX_USAGE="USAGE:   "
MSG_PREFIX_QUERY="-------> "
MSG_PREFIX_LOG="LOG:     "

MSG_FD=2

print_msg()
{
  mode="$1"; shift

  if [ "$mode" = "$MSG_SAME" ]
  then
    type="$MSG_SAME"
  else
    type=`echo "$mode" | sed 's/^[^A-Z]*\([A-Z]\).*$/\1/'`
    MSG_FD=`echo $mode"_2" | sed 's/^[^0-9]*\([0-9][0-9]*\).*$/\1/'`
  fi

  prefix="$MSG_PREFIX"

  # set prefix
  case "$type" in
    $MSG_INFO)
      prefix="$MSG_PREFIX_INFO"
      ;;
    $MSG_ERROR)
      prefix="$MSG_PREFIX_ERROR"
      ;;
    $MSG_WARN)
      prefix="$MSG_PREFIX_WARN"
      ;;
    $MSG_NOTE)
      prefix="$MSG_PREFIX_NOTE"
      ;;
    $MSG_USAGE)
      prefix="$MSG_PREFIX_USAGE"
      ;;
    $MSG_QUERY)
      prefix="$MSG_PREFIX_QUERY"
      ;;
    $MSG_LOG)
      prefix="$MSG_PREFIX_LOG"
      ;;
    $MSG_SAME)
      prefix="$MSG_PREFIX"
      ;;
  esac

  for msg in "$@" ; do
    # concatenate with prefix
    msg="$prefix$msg"
    prefix="         "
  
    if [ "$type" != "$MSG_LOG" ]
    then
      # output message
      echo "$msg" >&$MSG_FD
    fi
  
    # if logging is enabled log the message
    if [ -n "$MSG_LOGFILE" ]
    then
      echo "$msg" >> ${MSG_LOGFILE}
    fi

  done

  # set EXIT_CODE
  case "$type" in
    $MSG_ERROR)
      eval_exit ${FAILURE}
      ;;
    $MSG_WARN)
      eval_exit ${WARNING}
      ;;
  esac
}

enable_logging()
{
  MSG_LOGFILE="$1"
}

disable_logging()
{
  MSG_LOGFILE=""
}

############################################################################
# Usage

if [ $# != 0 ]
then
  print_msg ${MSG_NOTE} "Usage: ${PROGNAME}"
  exit 1
fi

############################################################################
# Set the pathname for 'sendmail' program based on the system type.

    SENDMAIL=/usr/sbin/sendmail

#####################################################
# Print the sendmail mail queue.

$SENDMAIL -bp 
 
exit $?

# end of script
