#!/usr/bin/ksh
# 
# Usage: err.sh <path> <numero d'erreur>
#
# Ce script permet d'analyser un fichier log applicatif de 2eme niveau.       
#
# Format d'un tel fichier :         
#     <numero d'erreur> <titre>
#     // *Cause : ...................
#     // ............................
#     // *Action : ..................
#     // ............................
#     /
#

if [ "$#" != "2" ]; then
	echo "Usage: $0 path error"
	echo ""
	echo "path : chemin d'acces au fichier log de 2eme niveau "
	echo "error : numero d'erreur"
	echo ""
	exit 
fi

ERRFILE=$1

if [ -r $ERRFILE ]
then
	shift
	for ERR in $*
	do
		awk "BEGIN	{ FOUND=0; }
		/^[0]*$ERR/ 	{ FOUND=1; print ; next;}
		/^\/\//		{ if (FOUND)
				  {
					print 
					next
				  }
	   			  else
					next;
				}
				{ if (FOUND)
					exit;
				   else
					next;
				} " $ERRFILE

	done
else
	echo Cannot find $ERRFILE file.
fi
