#!/serveur/dp/bin/perl -w

# 	$Id: CRASH.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Commandes passes avant un crash probable
#
# OBJET:  	Lance quelques commandes afin d'avoir des
#			informations si un crash arrive.
#			Les informations sont aussi stockes dans un
#			fichier log /var/tmp/ito_crash.log.
#
# usage : CRASH.pl nom_template
#
# Code retour :
#		0 : ok , 1 : erreur
#
# exemple : CRASH.pl bidon
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use Fcntl ':flock';
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = 0;

my $log = "/var/tmp/opc_crash.log";

# ---------------------------------------------------------------
# Affiche sur stdout et duplique dans un fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	print LOG @param;
	print @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# titre pour la commande  afficher
# ---------------------------------------------------------------
sub Titre {
	my($commande) = @_;
	Log("\n-----------------------------\n",
		"$commande\n",
		"-----------------------------\n\n");
}

# ---------------------------------------------------------------
# Diverses commandes pour faciliter un diagnostic
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my (@result,$message);
	my(%infos,%total);
	unlink $log if(-f $log);

	@result = ps("-ef");

	Titre("Proc infos");
	for(@result) {
		next if(/PID/);
		next if(/\s+$$\s+/);
		my($pid) = $1 if(/\s*\S+\s+(\d+)\s+/);
		my $total = 0;
		my $job;
		my @pmap = pmap($pid);
		for(@pmap) {
			next if(/^\s*total/); # pas de total dans toutes les versions
			$job = $_ if(/^$pid/);
			$total += $1 if(/^\S+\s+(\d+)K\s+/);
		}
		$total{$pid} = $total; # if($total>10000); # slt si > 10000Ko
		if($total{$pid}) {
			push(@pmap,"  total : ${total}K\n") if(grep(/^\s*total/,@pmap)==0);
			my @pstack = pstack($pid);
			my @pfiles = pfiles($pid);
			$infos{$pid} = "\n$job\n   ${total}K\nfiles\n\n@pfiles\nstack\n\n@pstack";
		}
	}
	for(sort { $total{$b} <=> $total{$a} } keys %total) {	# tri descending
		Log $infos{$_};
	}

	Titre("ps");
	Log @result;

	Titre("bdf");
	@result = bdf();
	for(@result) {
		my($filesystem,$type,$size,$used,$avail,$capacity,$mountpoint) = split(/\s+/);
		Log sprintf("%-40s %10s %10s %10s %4s %s\n",
					$filesystem,$size,$used,$avail,$capacity,$mountpoint);
	}

	Titre("ipcs");
	@result = ipcs("-a");
	Log @result;

	Titre("netstat -i");
	@result = netstat("-i");
	Log @result;
	Titre("netstat -s");
	@result = netstat("-s");
	Log @result;
	Titre("netstat -a");
	@result = netstat("-a");
	Log @result;

	return 0;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
