#!/serveur/dp/bin/perl -w

# 	$Id: SYS_ana.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Rcupration des informations d'un job dans le fichier syslog.
#		On prend les lignes contenant un pattern donn.
#
# usage : SYS_ana.pl <pattern>
#       pattern : pattern des lignes  slectionner
#
# exemple : SYS_ana.pl '[12345]:'    # pour un pid
#           SYS_ana.pl 'Link Down'
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my $pattern;

# ---------------------------------------------------------------
# Cette fct affiche les lignes du fichier syslog correspondant au
# job.
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my @ligne;
	my $ligne_prec;
	my $code = 0;
	my $fic = SysLog();
	if(open(LOG,"<$fic")) {
		my @lignes = grep(/$pattern/,<LOG>);
		close(LOG);
		my $nb = @lignes;
		if($nb>1) {
			print "\n  $nb lignes trouvees\n\n";
		} else {
			print "\n  $nb ligne trouvee\n\n";
		}
		print "@lignes" if($nb>0);
	} else {
		print "open $fic : $!\n";
		$code = 1;
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : pattern
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	my $nb = @ARGV;
	if($nb!=1) {
		print "Erreur parametrage : @ARGV";
		return 1;
	}
	$pattern=shift(@ARGV);
	$pattern = quotemeta($pattern);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
#my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

#Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
# if($NomTemplate eq "bidon") {
# 	exit $RetourITO;
# } else {
# 	opcmon("$NomTemplate=$RetourITO");
# 	exit 0;
# }

exit $RetourITO;

__END__
