#!/serveur/dp/bin/perl -w

# Surveillance des processus Tivoli, oserv et lcfd
#		
# usage : PROC_tiv.pl <nom_template>
#
# Code retour :
#		0 : ok, 2 : alerte ITO
#
# exemple : PROC_tiv.pl PROC_tiv
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;
require "hostname.pl";

my (%user,%nb_process,%nb);
# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# Determine si le noeud est une Gateway ou un Endpoint Tivoli
# 0 : Pas de noeud Tivoli install
# 1 : Endpoint
# 2 : Gataway
# 3 : Serveur
# ---------------------------------------------------------------

sub Type_noeud {
	my $type;
	my $host = hostname();
	Trace "Recherche du type de noeud Tivoli" if($debug);
	if ($host eq "guynemer" || $host eq "saintex") {
		Trace "Type : Serveur" if ($debug);
		$type = 3;
	}
	elsif (-d "/opt/Tivoli" && -d "/tivswap"){
		Trace "Type : Gataway" if ($debug);
		$type = 2;
	}
	elsif (-d "/opt/Tivoli") {
		Trace "Type : Endpoint" if ($debug);
		$type = 1;
	}
	else {$type = 0;}
	return $type;
}

# ---------------------------------------------------------------
# Vrification des process en fonction du type du noeud 
# ---------------------------------------------------------------

sub Verif_process {
	Trace "Verification des process" if($debug);
	my $code = 0;
	print "Processus demandes :\n\n";
	for(sort keys %user) {
		printf "       %-8s %s\n",$user{$_},$_;
	}
	my @result = ps("-ef");
	print "\nProcessus actifs :\n\n";
	printf("%10s %7s %7s %10s %8s %s\n","UID","PID","PPID","STIME","TIME","CMD");
	for(@result) {
		next if(/^\s*(\S+)\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/<defunct>/);
		next if(/UID/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd) = ($1,$2,$3,$4,$5,$6,$7);
			my @cmds = split(/\s+/,$cmd);
			map($_ = basename($_), @cmds);
			foreach my $test (keys %user) {
				if($uid =~ /^\s*($user{$test})\s*$/) {
					for(@cmds) {
						if(/^\s*($test)\s*$/) {
							printf("%10s %7s %7s %10s %8s %s\n",$uid,$pid,$ppid,$stime,$time,$cmd);
							$nb{$test}++;
							Trace "$test $nb{$test}" if($debug);
						}
					}
				}
			}
		} else {
			print "\nligne non reconnue :\n$_\n";
		}
	}
	print "\nProcessus non actifs :\n\n";
	foreach my $test (sort keys %user) {
		if($nb{$test}<$nb_process{$test}) {
			Trace "$test nb{$test}" if($debug);
			printf "       %3d %-8s %s\n",$nb_process{$test}-$nb{$test},$user{$test},$test;
			my @controle = grep(/($test)/,@result);
			print @controle if(@controle);
			$code = 2;
		}
	}
	return $code;
}

# ---------------------------------------------------------------------
# Traitement : On verifie les process lcfd (pour tous les noeud Tivoli)
# et oserv en plus pour les gataway.
# ---------------------------------------------------------------------

sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	if (Type_noeud() == 3) {
		%user = ("oserv","root");
		%nb_process = ("oserv",1);
		print "\nVerification des process\n\n";
		$code = 2 if(Verif_process()>0);
	}
	if (Type_noeud() == 2) {
		%user = ("lcfd","root","oserv","root");
		%nb_process = ("lcfd",1,"oserv",1);
		print "\nVerification des process\n\n";
		$code = 2 if(Verif_process()>0);
	}
	if (Type_noeud() == 1) {
		%user = ("lcfd","root");
		%nb_process = ("lcfd",1);
		print "\nVerification des process\n\n";
		$code = 2 if(Verif_process()>0);
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	my $code = 0;
	return $code;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "param=@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}
