#!/serveur/dp/bin/perl -w

# 	$Id: PROC_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance de process
#		
# usage : PROC_sur.pl nom_template [nom_user nom_process ...]
#		nom_user : nom du user du processus devant tourner
#		nom_process : nom du processus devant tourner
#
#		On peut utiliser les caracteres generiques (a la mode perl)
#		pour decrire le user et le process. Mais il est preferable de
#		s'assurer de l'unicite du user/process recherche.
#
# Code retour :
#		On renvoie le nombre de process actifs.
#		On compte 0 ou 1 par pattern.
#		Par exemple 'uu.*' renverra 1 meme si on a
#		plusieurs process de ce nom qui tournent.
#
# exemple : PROC_sur.pl PROC_sur rtc root 'uu.*'
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use Fcntl ':flock';
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my %nb;
my %user;
my $log = "/var/tmp/opc_procsur.log";

# ---------------------------------------------------------------
# stocke sortie dans fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	print LOG @param;
	print @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# tout est base sur un ps qui renvoie $uid,$pid,$ppid,$cmd
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $nb = 0;
	my @result = ps("-ef");
	Log "\nProcessus actifs :\n\n";
	my $texte = sprintf "%10s %7s %7s %10s %11s %s\n","UID","PID","PPID","STIME","TIME","CMD";
	Log $texte;
	my $script = basename($0);
	for(@result) {
		next if(/^\s*(\S+)\s+$$\s+/);	# suppression process en cours
		next if(/$script/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/UID/);
		next if(/defunct/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd)=($1,$2,$3,$4,$5,$6,$7);
			my @cmds = split(/\s+/,$cmd);
			my $i=0;
			for($i=0;$cmds[$i];$i++) {
				($cmds[$i]) = split(/\s+/,$cmds[$i]);
				$cmds[$i] = basename($cmds[$i]);
			}
			for(sort keys %user) {
				my $test = $_;
				if($uid =~ /^\s*($user{$test})\s*$/) {
					for(@cmds) {
						if(/^\s*($test)\s*$/) {
							$texte = sprintf("%10s %7s %7s %10s %11s %s\n",
											$uid,$pid,$ppid,$stime,$time,$cmd);
							Log $texte;
							$nb{$test}++;
						}
					}
				}
			}
		} else {
			Log "\nligne non reconnue :\n$_\n";
		}
	}
	Log "\nProcessus non actifs :\n\n";
	for(sort keys %user) {
		if($nb{$_}==0) {
			Log "    $user{$_}  $_\n";
		} else {
			$nb++;
		}
	}
	return $nb;
}

# ---------------------------------------------------------------
# lecture des parametres : liste des doublons user/processus
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	Log "\nProcessus demandes :\n\n";
	while(@ARGV) {
		my $user = shift(@ARGV);
		if(@ARGV) {
			my $cmd = shift(@ARGV);
			$nb{$cmd}=0;
			$user{$cmd}=$user;
			Log "    $user  $cmd\n";
		} else {
			Log "Erreur parametrage\n";
			return 1;
		}
	}
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);
$log = "/var/tmp/opc_proc_${NomTemplate}.log";
unlink $log if(-f $log);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
