#!/serveur/dp/bin/perl -w

# 	$Id: PROC_gdg.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance des processus GDG, mux et dspserv
# toutes instances gdg
#		
# usage : PROC_gdg.pl <nom_template>
#
# Code retour :
#		0 : ok, 2 : alerte ITO
#
# exemple : PROC_gdg.pl PROC_gdg
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;
require "hostname.pl";

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my($instance,%nb,%user,%nb_process);
my $user_en_ano;
my @instances_a_tester = ('gdg','gdgfor','gdgbis');

# ---------------------------------------------------------------
# Recherche les instances GDG pour le host
# ---------------------------------------------------------------
sub Instances {
	Trace "Recherche instances" if($debug);
	my @instances;
	chomp(my $hostname = hostname());
	for(@instances_a_tester) {
		my $user = $_;
		my($code,@result) = cfgtest("$user","-d all_servers_gdg");
		my $on_y_est = 0;
		for(@result) {
			$on_y_est = 1 if(/DEFINED NAMES/);
			next if(/DEFINED NAMES|all_servers_gdg|^cfgtest:|not defined/);
			next if($on_y_est==0);
			if(/^\s*(\S+)\s*$/) {
				my $host = $1;
				push(@instances,$user) if($hostname =~ /^(phys-|)$host$/);
			}
		}
	}
	return @instances;
}

# ---------------------------------------------------------------
# tout est base sur un ps qui renvoie $uid,$pid,$ppid,$cmd
# ---------------------------------------------------------------
sub VerifProcess {
	Trace "Traitement" if($debug);
	my $code = 0;
	print "Processus demandes :\n\n";
	for(sort keys %user) {
		$nb{$_} = 0;
		printf "       %3d %-8s %s\n",$nb_process{$_},$user{$_},$_;
	}
	my @result = ps("-ef");
	print "\nProcessus actifs :\n\n";
	printf("%10s %7s %7s %10s %8s %s\n","UID","PID","PPID","STIME","TIME","CMD");
	for(@result) {
		next if(/^\s*(\S+)\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/<defunct>/);
		next if(/UID/);
		if(/^\s*(\S+)\s+(\d+)\s+(\d+)\s+\S+\s+(\w+\s+\d+|\d+:\d+:\d+)\s+(\S+)\s+(\S+)\s+(.+)$/) {
			my($uid,$pid,$ppid,$stime,$tty,$time,$cmd) = ($1,$2,$3,$4,$5,$6,$7);
			my @cmds = split(/\s+/,$cmd);
			map($_ = basename($_), @cmds);
			foreach my $test (keys %user) {
				if($uid =~ /^\s*($user{$test})\s*$/) {
					for(@cmds) {
						if(/^\s*($test)\s*$/) {
							printf("%10s %7s %7s %10s %8s %s\n",$uid,$pid,$ppid,$stime,$time,$cmd);
							$nb{$test}++;
							Trace "$test $nb{$test}" if($debug);
						}
					}
				}
			}
		} else {
			print "\nligne non reconnue :\n$_\n";
		}
	}
	print "\nProcessus non actifs :\n\n";
	foreach my $test (sort keys %user) {
		if($nb{$test}<$nb_process{$test}) {
			Trace "$test nb{$test}" if($debug);
			printf "       %3d %-8s %s\n",$nb_process{$test}-$nb{$test},$user{$test},$test;
			my @controle = grep(/($test)/,@result);
			print @controle if(@controle);
			$code = 2;
		}
	}
	return $code;
}


# ---------------------------------------------------------------
# On contrle les process GDG : muxd et dspserv
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	my @instances = Instances();
	for(@instances) {
		my $user = $_;
		my $nb_mux = @instances;
		%user = ("muxd","root","dspserv","$user");
		%nb_process = ("muxd",$nb_mux,"dspserv",1);
		my $code1 = 0;
		print "\nVerification $user\n\n";
		$code1 = 2 if(VerifProcess()>0);
		if($code1!=0) {
			if($user_en_ano) {
				$user_en_ano = "$user_en_ano,$user";
			} else {
				$user_en_ano = "$user";
			}
		}
		$code = $code1 if($code1>$code);
	}
	$user_en_ano = "aucun" if(!$user_en_ano);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	my $code = 0;
	return $code;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "param=@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO user=$user_en_ano" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO -option user=$user_en_ano");
	exit 0;
}

__END__
