#!/serveur/dp/bin/perl -w

# 	$Id: ORA_sur.pl,v 2.5 2001/01/09 09:54:37 legranau Exp $	

# ---------------------------------------------------------------
#
# Surveillance Oracle
#
# Surveillance des process Oracle.
#
# usage : ORA_sur.pl <nom_template>
#
# NOTA :
#   processus arch_<inst> : seulement si log_archive_start dans init_<inst>.ora
#   processus ckpt_<inst> : seulement si checkpoint dans init_<inst>.ora
#   processus orasrv : seulement pour Oracle version < 7.3
#
# Il serait aussi bon de faire tourner sql*net :
#   sqlplus toto/toto@instance : renvoie la version + ORA user invalide
#   sql*net v2 sur tous
#   sql*net v1 pour version rdbms <= 7.1
#
# Code retour :
#		0 : ok , 1 : erreur, 2 : alarme ITO
#
# exemple : ORA_sur.pl ORA_pro
#
# ---------------------------------------------------------------

use strict;
require("hostname.pl");
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my @process = qw(lgwr dbw[r0] smon pmon); # process non obligatoires : arch reco
my $host = hostname();
$host =~ s/^phys-//;

# -----
# Ajout JYG
# -----
 
my $user = "sys";
my $password = "kimono";
my $fichier = "/var/opt/OV/bin/OpC/actions/fichier.sql";
my $oracle_victor = "/logiciel/oracle_mgr";
my $oracle_jle = "/logiciel/oracle";
my @liste_serveur= `cat /var/opt/OV/bin/OpC/actions/serveur_dev`;

# ---------------------------------------------------------------------
# lance commande avec timeout
# ---------------------------------------------------------------------
sub timeout {
	my ($param,$delai) = @_;
	my(@result);
	eval {
		local $SIG{ALRM} = sub { die "timeout\n" };
		alarm $delai;
		@result = `$param`;
		alarm 0;
	};
	@result = $@ if($@);
	sleep 1;
	return @result;
}

# ---------------------------------------------------------------
# Vrification du processus tnslsnr commun  toutes les instances.
# Vrification des processus pour chaque instance.
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	my $nb = 0;
	my $obligatoire = 0;
	my @instance = InstanceOracle($host);
	Trace "instances : @instance" if($debug);
	for(@instance) {
		my($instance,$rep,$boot) = split(/:/);
		$obligatoire++ if($boot =~ /Y/ && ! IsCluster());
	}
	my @result = ps("-ef");
	if(grep(/tnslsnr/,@result)==0) {
		print "Le processus tnslsnr absent.\n";
		print "Ce processus est necessaire a toutes les instances.\n";
		$code = 2 if($obligatoire>0);
	}
	print "\nProcessus demandes :\n\n";
	for(@process) {
		print " $_\n";
	}
	for("/logiciel","/home/logiciel","$host/logiciel") {
		my $rep1 = "$_";
		for("oracle","oracle_mgr") {
			my $rep2 = "$rep1/$_";
			for("tnsadmin","tns_admin") {
				my $rep3 = "$rep2/$_";
				$ENV{TNS_ADMIN} = $rep3 if(-d $rep3);
			}
		}
	}
	if(! $ENV{TNS_ADMIN} || ! -d $ENV{TNS_ADMIN}) {
		for(@instance) {
			my($instance,$rep,$boot) = split(/:/);
			$ENV{TNS_ADMIN} = "$rep/tns_admin" if(-d "$rep/tns_admin");
			$ENV{TNS_ADMIN} = "$rep/tnsadmin" if(-d "$rep/tnsadmin");
		}
	}
	for(@instance) {
		my($instance,$rep,$boot) = split(/:/);
		my($rien,$version) = split(/_/,basename($rep));
		$version = 7340 if(!$version); # version non indique
		$version = $version/10 if($version>1000); # 4 chiffres dans la version
		next if($version<716); # avant a passe pas l'an 2000
		next if(IsCluster()
				&& ! -d "/$host/logiciel/oracle_$instance"
				&& ! -d "/$host/home/logiciel/ora_$instance"); # cluster non bascul
		my %table;
		my $code2 = 0;
		my @process_inst = @process;
		push(@process_inst,'reco') if($instance ne 'lc'); # pour sisyphe
		print "\nVerification de l'instance $instance ($rep) :\n\n";
		print " >> instance non obligatoire <<\n"
			if($boot =~ /N/ || IsCluster());
		my $listener_log; my $valeur; my $nom_list;
		$listener_log = `ls -al $rep/network/log/listener.log` if ( -f "$rep/network/log/listener.log");
		$listener_log = `ls -al $rep/network/log/listener.$instance.log` if ( -f "$rep/network/log/listener.$instance.log");
		if(defined($listener_log)) { ($rien,$rien,$rien,$rien,$valeur,$rien,$rien,$rien,$nom_list)=split (/\s+/,$listener_log);}
		else{$valeur=0;}
		if ($valeur>80000000){print "Log du listener $nom_list trop gros\n";$code=$code2=2;}
		my $init_ora;
		for("/logiciel/oracle_$instance","/home/logiciel/ora_$instance",
			"/$host/logiciel/oracle_$instance","/$host/home/logiciel/ora_$instance",
			"$rep/dbs","/$host$rep/dbs") {
			$init_ora = "$_/init_$instance.ora" if(-f "$_/init_$instance.ora");
			$init_ora = "$_/init$instance.ora" if(-f "$_/init$instance.ora");
		}
		if(!$init_ora) {
			print "  Fichier init_$instance.ora non trouve.\n";
			$code = 2;
		} else {
			if(open(ORA,$init_ora)) {
				while(<ORA>) {
					next if(/^\#|^\s*$/);
					push(@process_inst,'ckpt') if(grep(/ckpt/,@process_inst)==0
												  && /^\s*checkpoint_process\s*=\s*true/);
					push(@process_inst,'arch') if(grep(/arch/,@process_inst)==0
												  && /^\s*log_archive_start\s*=\s*true/);
				}
				close(ORA);
			} else {
				print "  open $init_ora: $!\n";
				$code = 1;
			}
		}
		my $core = 0;
		my $dir_inst = $rep;
		$dir_inst = basename($init_ora) if($init_ora);
		if($dir_inst =~ /\/dbs$/) {
			$dir_inst = basename($dir_inst);
		}
		$core = scalar(glob("$dir_inst/rdbms/core_*")) if(-d "$dir_inst/rdbms");
		$core += scalar(glob("$dir_inst/rdbms/log/core_*")) if(-d "$dir_inst/rdbms/log");
		if($core>30) {
			print "  core dans rdbms.\n";
			$code = 2;
		}
		for(@process_inst) {
			my $process = "ora_${_}_$instance";
			$table{$process} = 0;
			$table{$process}++ if(grep(/$process/,@result)>0);
		}
		for(keys %table) {
			if($table{$_} == 0) {
				print "  processus $_ absent\n";
				$code = 2 if($boot =~ /Y/ && ! IsCluster());
				$code2 = 2;
			}
		}
		$ENV{ORACLE_HOME} = $rep;
		$ENV{TNS_ADMIN} = "$rep/tns_admin" if(! $ENV{TNS_ADMIN} && -d "$rep/tns_admin");
		$ENV{TNS_ADMIN} = "$rep/tnsadmin" if(! $ENV{TNS_ADMIN} && -d "$rep/tnsadmin");
		$ENV{TNS_ADMIN} = "$rep/network/admin" if(! $ENV{TNS_ADMIN} && -d "$rep/network/admin");
		if($code2 == 0) {		# pas de test s'il manque des process
			if(! $ENV{TNS_ADMIN} || ! -d $ENV{TNS_ADMIN}) {
				print "  tnsadmin non trouve\n";
				$code2 = $code = 2;
			} else {
				if($version < 716) {			# test sqlplus v1
					my @result = sqlplus("user_verole/passwd_verole\@t:$host:$instance","");
					if(grep(/ORA-01017/,@result)==0) {
						print "  probleme de connexion sqlplus v1 : @result\n";
						$code2 = $code = 2 if($boot =~ /Y/ && ! IsCluster());
					}
				}
				my @result = sqlplus("user_verole/passwd_verole\@$instance","");
				if(grep(/ORA-01017/,@result)==0) {
					print "  probleme de connexion sqlplus v2 : @result\n";
					$code2 = $code = 2 if($boot =~ /Y/ && ! IsCluster());
				}
			}
		}
		if($code2 == 0) {
			print "  $instance ok\n";
     
			# ---------
			# Ajout JYG
			# ---------
			if ( grep (/$host/,@liste_serveur)==0){ 
				my @result = sqlplus("$user/$password\@$instance \@$fichier","");
				for (@result) {
					
					if($_  =~ /Manque/) {
						print "  probleme sur l instance $instance : $_\n";
						$code2 = $code = 2;
					}
				}
			}
		}
	}
	print "\n";
	if($code>0) {
		print "\n\nEnvironnement\n\n";
		for(sort keys %ENV) {
			print "$_=$ENV{$_}\n";
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : process a surveiller
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
