#!/serveur/dp/bin/perl -w

# 	$Id: MAIL_serv.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Envoi de mails lors des alarmes
#		
# usage (1) : MAIL_ala.pl <paramtres ITO>
#		appel par la notification externe, avec les paramtres ITO :
#		Message ID, Source node, Source node type, Date created,
#		Time created, Date received, Time received, Application,
#		Message group, Object, Severity, Responsible operators,
#		Message text, Instruction
#
# usage (2) : MAIL_ala.pl [-ack] <Message ID>
#		lancement en action oprateur
#		Message ID : du message qu'on envoie en mail
#		-ack : acknowledge le message si le mail est envoy avec succs
#				cette option doit tre en premier paramtre
#
# usage (3) : MAIL_ala.pl -cron <user>
#		lancement par cron pour envoyer les mails stocks
#		l'option -cron doit tre en premier paramtre
#		user : nom de la mailbox  envoyer
#
# Code retour :
#		0 : ok, 1 : problme
#
# ---------------------------------------------------------------
# ---------------------------------------------------------------
# ATTENTION : aucun parametre n'est admis dans l'indication du
# script de notification dans ITO.
# ---------------------------------------------------------------

use strict;
use DBI 1.13;
require "hostname.pl";
use POSIX 'strftime';
use Socket;
use Carp;
use Fcntl ':flock';
use Time::localtime;
use File::Basename;
use lib dirname($0);
use dits_def;

my $debug = Debug();
Trace "$0" if($debug);

# ---------------------------------------------------------------
# fonctionnement en client-serveur
# ---------------------------------------------------------------
my $port = 23456;
my $proto = getprotobyname('tcp');

# ---------------------------------------------------------------
# connection  la base
# ---------------------------------------------------------------
my $dbh;
my $data_source = hostname();
my $username = "opc_op";
my $passwd = "opc";

# ---------------------------------------------------------------
# rpertoire de stockage des mails
# ---------------------------------------------------------------
my $stockage = "/var/opt/OV/log/OpC/opc_mail";

# ---------------------------------------------------------------
# configuration
# ---------------------------------------------------------------
my $configuration = dirname($0) . "/MAIL_ala.cfg";
my @configuration;
my %mail_addr;
my $conf_date = 0;

# ---------------------------------------------------------------
# rcupration du code status des annotations
# ---------------------------------------------------------------
sub auto_status {
	my ($message_id) = @_;
	my $auto_status = 12;
	my (@enreg,$sth);
	my $requete_auto = "select auto_status from opc_act_messages
		where message_number = \'$message_id\'";

	$sth = $dbh->prepare(qq{$requete_auto}) if($dbh);
	if(!$sth) {
		Trace "Erreur preparation \"$requete_auto\": $DBI::errstr";
	} else {
		if($sth->execute) {
			while ( @enreg = $sth->fetchrow_array ) {
				$auto_status = $enreg[0];
			}
		} else {
			Trace "Erreur execution \"$requete_auto\": $DBI::errstr";
		}
		$sth->finish;
		Trace $DBI::errstr if $DBI::err;
	}
	return $auto_status;
}

# ---------------------------------------------------------------
# rcupration des annotations
# il faut une temporisation car l'action automatique lance n'est
# pas forcment termine
# ---------------------------------------------------------------
sub annotations {
	my ($message_id) = @_;
	my (@annotations,@temp,@result);
	my (@enreg,$sth);

	my %texte_auto_status = (2,"Action automatique en erreur\n",
							 8,"Action automatique en cours\n",
							 9,"Action automatique ok\n",
							 11,"Action automatique disponible\n",
							 12,"Pas d'action automatique\n");

	my $requete_anno = "select auto_anno_flag from opc_act_messages
		where message_number = \'$message_id\'";

	my $requete_texte = "select txt.text_part
		from opc_annotation ann, opc_anno_text txt
		where ann.message_number = \'$message_id\'
		and ann.anno_text_id = txt.anno_text_id
		order by txt.anno_text_id, txt.order_number";

	my $auto_anno = 0;
	$sth = $dbh->prepare(qq{$requete_anno}) if($dbh);
	if(!$sth) {
		Trace "Erreur preparation \"$requete_anno\": $DBI::errstr";
	} else {
		if($sth->execute) {
			while ( @enreg = $sth->fetchrow_array ) {
				$auto_anno = $enreg[0];
			}
		} else {
			Trace "Erreur execution \"$requete_anno\": $DBI::errstr";
		}
		$sth->finish;
		Trace $DBI::errstr if $DBI::err;
	}
	if($auto_anno==0) {
		@annotations = (@annotations,"Pas d'annotations prvues\n");
	} elsif($auto_anno==1) {
		@annotations = (@annotations,"Annotations prvues\n") if($debug);
	} else {
		@annotations = (@annotations,"code AUTO_ANNO_FLAG = $auto_anno inconnu\n");
	}

	if($auto_anno==0) {
		return @annotations;
	}

	my $retry = 1;
	my $auto_status = auto_status($message_id);
	while($retry<6 && $auto_status==8) {	# action automatique encore en cours
		sleep 5;
		$auto_status = auto_status($message_id);
		$retry++;
	}
	if($texte_auto_status{$auto_status}) {
		@annotations = (@annotations,$texte_auto_status{$auto_status}) if($debug);
	} else {
		@annotations = (@annotations,"code AUTO_STATUS = $auto_status inconnu\n");
	}

	$sth = $dbh->prepare(qq{$requete_texte}) if($dbh);
	if(!$sth) {
		Trace "Erreur preparation \"$requete_texte\": $DBI::errstr";
	} else {
		if($sth->execute) {
			while ( @enreg = $sth->fetchrow_array ) {
				@annotations = (@annotations,$enreg[0]);
			}
		} else {
			Trace "Erreur execution \"$requete_texte\": $DBI::errstr";
		}
		$sth->finish;
		Trace $DBI::errstr if $DBI::err;
	}
	return @annotations;
}

# ---------------------------------------------------------------
# rcupration du texte du message
# ---------------------------------------------------------------
sub msg_text {
	my ($message_id) = @_;
	my @temp;
	my (@enreg,$sth);

	my $requete_texte = "select txt.text_part
		from opc_msg_text txt
		where txt.message_number = \'$message_id\'
		order by txt.order_number";

	$sth = $dbh->prepare(qq{$requete_texte}) if($dbh);
	if(!$sth) {
		Trace "Erreur preparation \"$requete_texte\": $DBI::errstr";
	} else {
		if($sth->execute) {
			while ( @enreg = $sth->fetchrow_array ) {
				@temp = (@temp,$enreg[0]);
			}
		} else {
			Trace "Erreur execution \"$requete_texte\": $DBI::errstr";
		}
		$sth->finish;
		Trace $DBI::errstr if $DBI::err;
	}
	@temp = ("Aucun message disponible") if(!@temp);
	return @temp;
}

# ---------------------------------------------------------------
# stocke le mail pour envoi ultrieur
# il faut un lock pour ne pas crire les mails  plusieurs
# ---------------------------------------------------------------
sub stocke_mail {
	my ($user,$sujet,$texte) = @_;
	my $mailbox = "$stockage/$user";
	my $code = 0;
	if(! -d "$stockage") {
		mkdir("$stockage",0755);
	}
	if(open(MAIL,">>$mailbox") && flock(MAIL,LOCK_EX)) {
		seek(MAIL,0,2);
		print MAIL "$sujet\n\n$texte\n";
		print MAIL "------------------------------------------\n\n";
		close(MAIL);
		flock(MAIL,LOCK_UN);
	} else {
		Trace "open lock $mailbox : $!";
		$code = 1;
	}
	return $code;
}

# ---------------------------------------------------------------
# envoi du mail avec copie  l'administrateur
# ---------------------------------------------------------------
sub send_mail {
	my ($user,$subject,$texte,$copie) = @_;
	my $code = 1;
	my $headers = "To: $mail_addr{$user}";
	$headers = "$headers\nBcc: $mail_addr{opc_adm}" if($copie);
	$headers = join("\n",
					"$headers",
					"Reply-To: $mail_addr{opc_adm}",
					"Subject: $subject",
					"X-Mailer: ITO 5",
					"Mime-Version: 1.0",
					"Content-Transfer-Encoding: 8bit",
					"Content-Type: text/plain; charset=iso-8859-1");
	$code = mail("$headers\n$texte","-F'ITO 5' -t");
	stocke_mail($user,$subject,$texte) if($code>0);
	return $code;
}

# ---------------------------------------------------------------
# envoie les mails stocks avec une synthse
# ---------------------------------------------------------------
sub destocke_mail {
	my ($user) = @_;
	my $mailbox = "$stockage/$user";
	my $code = 0;
	if(-s "$mailbox") {
		if(open(MAIL,"+<$mailbox") && flock(MAIL,LOCK_EX)) {
			my @texte = <MAIL>;
			if($user eq 'opc_adm') {
				my (%nb,%serveurs,@synthese,$serveur);
				for(@texte) {
					$serveur = $1 if(/Message cr sur (\S+)/);
					if(/CMD:\s+(.+)$/) {
						my $cmd = $1;
						$cmd =~ s/\s+$//;
						$cmd =~ s/^\s+//;
						$nb{$cmd}++;
						$serveur =~ s/\.\S+$//;
						$serveurs{$cmd} .= "$serveur "
							if(!$serveurs{$cmd} || grep(/$serveur /,$serveurs{$cmd})==0);
					}
				}
				my $ligne = sprintf "\n\nNombre  Commande\n\n";
				push(@synthese,$ligne);
				for(sort { $nb{$b} <=> $nb{$a} } keys %nb) {	# tri sur nb descending
					$ligne = sprintf "%4d    %s\n",$nb{$_},$_;
					push(@synthese,$ligne);
					$ligne = sprintf "%4s    %s\n",' ',$serveurs{$_};
					push(@synthese,$ligne);
				}
				my $synthese = join('',@synthese);
				$code = send_mail($user, "OpC Synthese des alertes", $synthese,0);
			}
			my $texte = join('',@texte);
			$code = send_mail($user, "OpC Liste des alertes", $texte,0);
			if($code==0) {
				seek(MAIL,0,0);
				truncate(MAIL,0);
			}
			close(MAIL);
			flock(MAIL,LOCK_UN);
		} else {
			Trace "open $mailbox : $!";
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# inverse jour/mois dans une date
# ---------------------------------------------------------------
sub inverse {
	my($date) = @_;
	my($mois,$jour,$an) = split(/\//,$date);
	if($mois && $jour && $an) {
		$date = "$jour/$mois/$an";
	}
	return $date;
}

# ---------------------------------------------------------------
# rcupre les infos du message
# ---------------------------------------------------------------
sub infos_msg {
	my ($message_id) = @_;
	my($source_node,$source_node_type,$date_created,
	   $time_created,$date_received,$time_received,$application,
	   $message_group,$object,$severity,$code_severity);
	my %texte_severity = (2, 'normal',
						  4, 'warning',
						  8, 'critical',
						  16, 'minor',
						  32, 'major');
	my (@enreg,$sth);

	my $requete = "select name.node_name, net.os_name, msg.creation_time, msg.receiving_time,
				msg.severity, msg.application, msg.message_group, msg.object
		from opc_op.opc_act_messages msg, opc_op.opc_nodes node,
				opc_op.opc_net_machine net, opc_node_names name
		where msg.message_number = \'$message_id\'
		and msg.node_id = node.node_id
		and node.node_id = name.node_id
		and net.machine_type = node.machine_type";

	$sth = $dbh->prepare(qq{$requete}) if($dbh);
	if(!$sth) {
		Trace "Erreur preparation \"$requete\": $DBI::errstr";
	} else {
		if($sth->execute) {
			while ( @enreg = $sth->fetchrow_array ) {
				($source_node,$source_node_type,$date_created,$date_received,$code_severity,
				 $application,$message_group,$object) = @enreg;
			}
		} else {
			Trace "Erreur execution \"$requete\": $DBI::errstr";
		}
		$sth->finish;
		Trace $DBI::errstr if $DBI::err;
	}

	if($texte_severity{$code_severity}) {
		$severity = $texte_severity{$code_severity};
	} else {
		$severity = "code $code_severity non trouv";
	}
	$date_created = ctime("$date_created");
	$date_received = ctime("$date_received");
	return ($source_node,$source_node_type,$date_created,$date_received,$application,
			$message_group,$object,$severity);
}

# ---------------------------------------------------------------
# dtermination des destinataires des mails
# ---------------------------------------------------------------
sub dispatch_mail {
	my ($message_id) = @_;
	my($source_node,$source_node_type,$date_created,
	   $time_created,$date_received,$time_received,$application,
	   $message_group,$object,$severity,$operators,$message_text,
	   $instructions,@msg_text);
	my $driver;
	my @drivers = DBI->available_drivers;
	for(@drivers) {
		$driver = $_ if(/Oracle/);
	}
	if(! $driver) {
		Trace "Le driver DBI Oracle n'est pas installe.\n";
	} else {
		$dbh = DBI->connect("dbi:$driver:$data_source",$username,$passwd);
		if(!$dbh) {
			Trace "Connexion impossible a $data_source: $DBI::errstr";
		}
	}
	if(@ARGV) {
		($source_node,$source_node_type,$date_created,
		 $time_created,$date_received,$time_received,$application,
		 $message_group,$object,$severity,$operators,$message_text,
		 $instructions) = (shift(@ARGV),shift(@ARGV),shift(@ARGV),shift(@ARGV),
						   shift(@ARGV),shift(@ARGV),shift(@ARGV),shift(@ARGV),
						   shift(@ARGV),shift(@ARGV),shift(@ARGV),shift(@ARGV),shift(@ARGV));
		Trace("node=$source_node") if($debug);
		@msg_text = ($message_text);
		$date_created = inverse($date_created);
		$date_received = inverse($date_received);
	} else {
		($source_node,$source_node_type,$date_created,$date_received,$application,
		 $message_group,$object,$severity) = infos_msg($message_id);
		@msg_text = msg_text($message_id);
		$message_text = join(' ',@msg_text);
		$time_created = $time_received = " ";
	}
	return 11 if(!$source_node || !$application || !$severity); # alerte absente des actifs
	my $host = hostname();
	my @annotations = annotations($message_id);
	my $texte = join("\n",
					 "Message cr sur $source_node $date_created $time_created",
					 "Message reu sur $host $date_received $time_received",
					 "",
					 "Application :  $source_node_type $application $message_group $object",
					 "Svrit :     $severity",
					 "",
					 "Message",
					 "-------",
					 "@msg_text",
					 "",
					 "Annotations",
					 "-----------",
					 "@annotations",
					 "");
	my $subject = "OpC $source_node $application $severity";
	my $code = 0;
	if($dbh) {
		$dbh->disconnect || Trace "$dbh->errstr";
	}

# tests pour les diffrents destinataires

	my $ok = 0;
	my $ack = 0;
	my $act = 0;
	for(@configuration) {
		next if(/^\#/);
		next if(/^$/);
		next if(/^ADDR/);
		my($test_node,$test_app,$test_group,$test_obj,$test_mess,$test_anno,
		   $action) = split(/:|\n/);
		Trace("conf $test_node,$test_app,$test_group",
			  ",$test_obj,$test_mess,$test_anno,$action") if($debug);
		Trace("test $source_node,$application,$message_group,$object,$message_text") if($debug);
		if((length($test_node)==0 || $source_node =~ /$test_node/)
		   && (length($test_app)==0 || $application =~ /$test_app/)
		   && (length($test_group)==0 || $message_group =~ /$test_group/)
		   && (length($test_obj)==0 || $object =~ /$test_obj/)
		   && (length($test_mess)==0 || $message_text =~ /$test_mess/)) {
			if(length($test_anno)>0) {
				$ok = 0;
				for(@annotations) {
					if(/$test_anno/) {
						$ok = 1;
						last;		# sort du for
					}
				}
			} else {
				$ok = 1;
			}
		}
		if($ok) {
			Trace("app=$application","group=$message_group","obj=$object",
				  "mes=$message_text") if($debug);
			Trace("ok pour $test_node,$test_app,$test_group",
				  ",$test_obj,$test_mess,$test_anno,$action") if($debug);
			my @action = split(/\s+/,$action);
			my $i=0;
			while($action[$i]) {
				if($action[$i] eq 'ack') {
					$ack = 1 ;
				} elsif($action[$i] eq 'drop') {
					last;
				} elsif($action[$i] eq 'mail+') {
					$i++;
					$code = send_mail($action[$i],$subject,$texte,1);
					Trace "mail+ $action[$i]" if($debug);
					$act = 1;
				} elsif($action[$i] eq 'mail') {
					$i++;
					$code = send_mail($action[$i],$subject,$texte,0);
					Trace "mail $action[$i]" if($debug);
					$act = 1;
				} elsif($action[$i] eq 'stocke') {
					$i++;
					$code = stocke_mail($action[$i],$subject,$texte);
					Trace "stocke $action[$i]" if($debug);
					$act = 1;
				} else {
					Trace "action non reconnue : $action[$i]";
				}
				$i++;
			}
			last;	# sort du while(<CONF>)
		}
	}
	if($code>0) {
		$texte = join("\n",$texte,"Erreur envoi mail code=$code");
		$code = send_mail("opc_adm",$subject,$texte,0);
		Trace "erreur envoi" if($debug);
	}
	if($code==0 && $ack) {
		if($act) {
			($code) = opcackmsg("-u mail_send $message_id");
		} else {
			($code) = opcackmsg("-u auto_ack $message_id");
		}
		Trace "ack" if($debug);
	}
	return $code;
}

# ---------------------------------------------------------------
# chargement du fichier de configuration s'il y en a besoin
# ---------------------------------------------------------------
sub lecture_conf {
	my($st_dev,$st_ino,$st_mode,$st_nlink,$st_uid,$st_gid,$st_rdev,$st_size,
	   $st_atime,$st_mtime,$st_ctime,$st_blksize,$st_blocks) = stat($configuration);
	if($st_mtime>$conf_date) {
		$conf_date = $st_mtime;
		if(open(CONF,"<$configuration")) {
			@configuration = <CONF>;
			close(CONF);
			for(@configuration) {
				next if(/^\#/);
				next if(/^$/);
				next if(! /^ADDR/);
				my($rien,$alias,$mails) = split(/:|\n/);
				$mail_addr{$alias}=$mails;
			}
		} else {
			Trace "open $configuration : $!";
		}
	}
}

# ---------------------------------------------------------------
# Ce programme est lanc en dmon. Il est appel par MAIL_ala.pl
# avec les mmes paramtres.
# Le dmon ne fork pas pour ne pas saturer la CPU.
# Il relit la configuration si besoin pour chaque mail.
# ---------------------------------------------------------------

Trace "[$$] server starting on port $port" if($debug);
socket(Server, PF_INET, SOCK_STREAM, $proto) || die "socket: $!";
setsockopt(Server, SOL_SOCKET, SO_REUSEADDR, pack("l", 1)) || die "setsockopt: $!";
bind(Server, sockaddr_in($port, INADDR_ANY)) || die "bind: $!";
listen(Server,SOMAXCONN) || die "listen: $!";

my $paddr;

for ( ; $paddr = accept(Client,Server); close Client) {
	lecture_conf();
	$debug = Debug();
	my($sock,$iaddr) = sockaddr_in($paddr);
	my $name = gethostbyaddr($iaddr,AF_INET);
	Trace "[$$] connection from $name at socket $sock" if($debug);
	chomp(my @param = <Client>);
	Trace "[$$] connecting for :\n@param\n" if($debug);
	my $nb = @param;
	my $code = 0;
	my $acknowledge = 0;
	my $force_acknowledge = 0;
	if($nb==2 && $param[0] eq "-cron") {
		$code = destocke_mail($param[1]);
	} elsif($nb>0) {
		if($param[0] eq "-ack") {
			shift(@param);
			$force_acknowledge = 1;
		}
		my $message_id = shift(@param);
		$acknowledge = 1 if($nb>1);
		$code = dispatch_mail($message_id);
	} else {
		Trace "erreur de parametrage";
	}
	Trace "[$$] server disconnecting code=$code" if($debug);
}

Trace "[$$] server aborting";
exit 0;

__END__
