#!/serveur/dp/bin/perl -w

# 	$Id: LOG_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance des logs Metaphase
#		
# usage : LOG_sur.pl nom_template [-force]
#		-force : alarme meme si le probleme semble vieux
#
# Code retour :
#		0 : ok, 2 : alerte ITO, 3 : fichier log non trouv
#
# exemple : LOG_sur.pl LOG_sur
#
# ---------------------------------------------------------------

use strict;
use Time::Local;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my $force = 0;
my $log_path = "/var/gdg_log";

my $filtre_muxlog = join('|','Mux started\.',
						 'Mux stop requested by',
						 'Mux terminated\.',
						 'processTcpRead: \S+: recv: Connection timed out',
						 'validateTcpConnect: rejecting a connection from a host which identifies itself as VC_HOSTNAME.* because this host has no entry in the hosts map');

my %filtre = ('dsplog','Dispatcher started|Dispatcher terminated',
			  'muxlog',$filtre_muxlog,
			  'dspout',0);

# ---------------------------------------------------------------
# on recupere une date (1999/03/25-04:50:31 par exemple)
# on teste si elle est vieille de 2h (ou 48h si force)
# ---------------------------------------------------------------
sub TropVieux {
	my ($param) = @_;
	my($jour_cour,$mois_cour,$annee_cour,$heure_cour,$min_cour,$sec_cour) =
		split(/:/,date("%d:%m:%Y:%H:%M:%S"));
	my $time_cour = timelocal($sec_cour,$min_cour,$heure_cour,
							  $jour_cour,$mois_cour-1,$annee_cour);
	my $time = $time_cour;
	if($param =~ /(\d+)\/(\d+)\/(\d+)-(\d+):(\d+):(\d+)/) {
		my($annee,$mois,$jour,$heure,$min,$sec) = ($1,$2,$3,$4,$5,$6);
		$time = timelocal($sec,$min,$heure,$jour,$mois-1,$annee)
			if($annee && $mois && $jour && $heure && $min && $sec);
	}
	my $ecart = 2 * 3600;
	$ecart = 48 * 3600 if($force);
	return 1 if($time_cour > $time + $ecart);
	return 0;
}

# ---------------------------------------------------------------
# On lit les logs dsplog.0 qui doivent contenir juste les 2 lignes :
# 1999/03/25-04:50:31 domino Dispatcher started.
# 1999/03/26-04:50:20 domino Dispatcher terminated.
#
# On lit les logs dspout.0 qui contiennent plein de salets
# (mais heureusement pas au format <date> <host> <message>).
#
# On lit les logs muxlog.0 qui doivent contenir juste les 3 lignes :
# 1999/10/02-04:50:18 cale Mux started.
# 1999/10/03-04:56:27 cale Mux stop requested by gdg
# 1999/10/03-04:56:27 cale Mux terminated.
#
# pas de message si fichier log absent
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $code = 0;
	my $rep;
	opendir(DIR,$log_path);
	while(defined($rep = readdir(DIR))) {
		next if($rep =~ /^(\.|\.\.)$/);
		next if($rep !~ /^(gdg|gdgfor|gdgbis)$/);	# slt oper/formation/bis surveill
		my $path = "$log_path/$rep";
		for(sort keys %filtre) {
			my $file = $_;
			my $code1 = 0;
			if(open(LOG,"<$path/$file.0")) {
				while(<LOG>) {
					next if(!/^\d+\/\d+\/\d+-\d+:\d+:\d+\s+\S+\s+/);
					next if($filtre{$file} && /$filtre{$file}/);
					my($date,$host,$message) = ($1,$2,$3) if(/^(\S+)\s+(\S+)\s+(.+)$/);
					$message = " " if(! $message);
					next if(TropVieux($date));
					print "\nErreur trouvee dans $path/$file.0 :\n\n" if($code1==0);
					print "$_";
					$code1 = 2;
				}
				close(LOG);
			}
			$code = $code1 if($code1>$code);
		}
	}
	closedir(DIR);
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	if(@ARGV) {
		$force = "-force" if($ARGV[0] eq "-force");
	}
	Trace "$force" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "param=@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if(!$NomTemplate || $NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
