#!/serveur/dp/bin/perl -w

# 	$Id: EMC_sur.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Surveillance des fibres optiques sur la baie EMC
#
# Surveillance par Power Path.
#		
# usage : EMC_sur.pl nom_template
#
# Code retour :
#		0 : ok, 2 : alarme ITO
#
# exemple : EMC_sur.pl EMC_sur
#
# ---------------------------------------------------------------

use strict;
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

# ---------------------------------------------------------------
# Surveillance des fibres optiques
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my $nb = 0;
	if(! VerifCommande("POWERMT")) {
		return 0;
	}
	my($code,@result) = powermt("display");
	for(@result) {
		my $ligne = $_;
		print "$ligne";
		next if(/^(total|==|--|\#\#)/);
		next if(/^\s*$/);
		if(/^\s*\d+\s+\S+\s+\S+\s+(\S+)\s+/) {
			my($summary) = $1;
			$code = 2 if($summary eq 'Failed' || $summary eq 'Degraded');
			$nb++;
		}
	}
	if($code==2) {
		print "\n>>>> ligne Failed ou Degraded\n";
	} elsif($nb<2) {
		$code = 2;
		print "\n>>>> $nb ligne etablie (au lieu de 2)\n";
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
