#!/serveur/dp/bin/perl -w

# 	$Id: CFT_sur.pl,v 2.10 2001/04/24 06:46:00 p004184 Exp $	

# ---------------------------------------------------------------
#
# Surveillance CFT
#
# Envoi et rception d'un fichier sur lui-mme
# pour vrifier le bon fonctionnement de CFT.
# Vrification de toutes les instances CFT
# trouves sur la machine.
# Comme l'excution est longue, on stocke les rsultats
# dans un fichier log pour consultation ultrieure.
#		
# usage : CFT_sur.pl < nom_template > [-log] [debut fin]
#		-log : renvoie juste le contenu du fichier log
#	    debut : heure dbut
#	    fin : heure fin
#
# Code retour :
#		0 : ok , 1 : erreur, 2 ou plus : alarme ITO
#
# exemple : CFT_sur.pl CFT_sur
#
# ---------------------------------------------------------------

use strict;
use Fcntl ':flock';
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my($HM0,$HM1,$liste_log);

my $log = "/var/tmp/opc_cftsur.log";

my @process = ('CFTTPRO','CFTMAIN','CFTTCPS','CFTTCOM','CFTLOG');

my @ps = ps("-ef");

# ---------------------------------------------------------------
# stocke sortie dans fichier log
# ---------------------------------------------------------------
sub Log {
	my @param = @_;
	open(LOG,">>$log") || Trace "open $log : $!";
	flock(LOG,LOCK_EX) || Trace "lock $log : $!";
	print LOG @param;
	print @param;
	flock(LOG,LOCK_UN);
	close(LOG);
}

# ---------------------------------------------------------------
# affiche le fichier log
# ---------------------------------------------------------------
sub print_log {
	my $code = 0;
	if(-f $log && open(LOG,"+<$log") && flock(LOG,LOCK_EX)) {
		print <LOG>;
		flock(LOG,LOCK_UN);
		close(LOG);
	} else {
		$code = 1;
	}
	return $code;
}

# ---------------------------------------------------------------
# On determine si on est dans l'intervalle horaire de surveillance ou non. 
# L'intervalle de surveillance est donne par 2 variables entrees en
# parametres de la forme 2300 0140 pour un arret de la surveillance 
# entre 23H et 1H40. Si aucune  variable n'est passee en parametre
# alors la surveillance est permanente.
# Verifie si l'intervalle ne se chevauche pas sur 2 jours
# ---------------------------------------------------------------
sub HeureOk {
	my($HM0,$HM1)=@_;
	if(($HM0 && $HM0>0) || ($HM1 && $HM1>0)) {
		my $HM=date("+%H%M");
		if(($HM1 > $HM0 && ($HM > $HM0 && $HM < $HM1))
		   || ($HM1 < $HM0 && ($HM > $HM0 || $HM < $HM1))) {
			return 0;
		}
	}
	return 1;
}

# ---------------------------------------------------------------
# consultation du catalogue
# renvoie l'IDENT du dernier message recu
# ---------------------------------------------------------------
sub GetIdent {
	my($instance,$rep) = @_;
	my $idt=0;
	my @result=cftutil($instance,$rep,"listcat type=all,part=LOCAL,idf=OUTX,direct=recv");
	for(@result) {
		$idt = $1 if(/(\S+)\s+TESTOPC_CFT/);
	}
	return $idt;
}

# ---------------------------------------------------------------
# cette fct permet de comparer l'identifiant du dernier message recu
# avec celui qu'elle vient d'envoyer, pour determiner si CFT fonctionne.
# Optimisation des lectures de catalogue avec l'ajout de idf=OUTX
# traitement :
# - on efface tous les enregistrements precedents 
# - emision d'un message
# - tempo 65s = duree max de prise en compte d'une commande par CFT
# - les 2 IDENT sont differents si le message a bien ete transmis
# ---------------------------------------------------------------
sub cftsur {
	my($instance,$rep) = @_;
	my $code = 0;
	my $CftIDTprec=GetIdent($instance,$rep);
	Trace "idtprec=$CftIDTprec" if($debug);
	cftutil($instance,$rep,"delete part=LOCAL,idf=OUTX");
	sleep 65;
	cftutil($instance,$rep,"send part=LOCAL,type=message,idm=OUTX,msg=TESTOPC_CFT");
	sleep 65;
	my $CftIDT=GetIdent($instance,$rep);
	Trace "idt=$CftIDT" if($debug);
	if($CftIDT eq $CftIDTprec) {
		Log("    $instance fonctionne mal\n\n");
		my @result=cftutil($instance,$rep,"listcat type=all,part=LOCAL,idf=OUTX");
		Log(@result);
		$code = 2;
	}
	return $code;
}

# ---------------------------------------------------------------
# CFT peut rester bloqu si une des instances est tombe en
# laissant le fichier LOCK, on lance donc une tche avec les appels
# CFT en fork, puis on lance une autre tche en fork pour surveiller
# la premire.
# ---------------------------------------------------------------
sub cftsur_controle {
	my($instance,$rep) = @_;
	my($cftsur_pid,@temp,$control_pid);
	my $code = 0;
	if (!defined($cftsur_pid = open(CFTSUR,"-|"))) {
		Log "cannot fork : $!\n";
		$code = 2;
	} elsif ($cftsur_pid == 0) {		######### I'm the cftsur child
		$code = 2;
		$code = cftsur($instance,$rep);
		exit $code;
	} else {							######### end cftsur child
		my @ps_label_mem = ps("-p $cftsur_pid -o stime,args");
		if (!defined($control_pid = open(CONTROL,"-|"))) {
			Log "cannot fork : $!\n";
		} elsif ($control_pid == 0) {	############ I'm the control child
			sleep 180;
			my @ps_label = ps("-p $cftsur_pid -o stime,args");
			if($ps_label_mem[1] && $ps_label[1] && "$ps_label_mem[1]" eq "$ps_label[1]") {
				Log("    $instance hors-service\n");
				kill(15,$cftsur_pid);
				sleep 10;
				$code = 2;
			}
			exit $code;
		} else {						######### end control child
			while((my $pid=wait())>0) {
				my $temp = $?;
				$code = 2 if($temp==2 || $temp==15);
				Trace "pid=$pid temp=$temp code=$code" if($debug);
				kill(9,$control_pid) if($pid==$cftsur_pid);
				kill(9,$cftsur_pid) if($pid==$control_pid);
			}
			close(CFTSUR);
			close(CONTROL);
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# Vrifie les process d'une instance
# ---------------------------------------------------------------
sub VerifProcess {
	my($instance) = @_;
	my %process;
	my $code = 0;
	for(@ps) {
		next if(/^\s*(\S+)\s+$$\s+/);	# suppression process en cours
		next if(/^$/);	# suppression lignes vides
		next if(/defunct/);
		$process{$2} = 1 if(/^\s*($instance)\s+.*\s+(CFT\S+)\s*$/);
	}
	for(@process) {
		if(!$process{$_}) {
			Log("\n    Processus manquant pour $instance :\n\n") if($code==0);
			Log "       $_\n";
			$code = 2;
		}
	}
	Log "    tous les processus sont presents\n" if($code==0);
	Log "\n";
	return $code;
}

# ---------------------------------------------------------------
# Vrifie les instances devant tourner avec la prsence d'un
# fichier LOCK
# Si ce dernier est absent pas besoin de continuer le programme
# la base est arretee.
# Test si on a une tranche horaire ou il ne faut pas verifier CFT.
# En cas de problme liste les process et les fichiers log
# cftgdg est un compte pour les batchs.
# cftxxxr sont pour la re7 pas de surveillance dessus
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	return print_log() if($liste_log);
	my $code = 0;
	unlink $log if(-f $log);
	for(CftDir()) {
		my $rep = $_;
		my $instance = basename($rep);
		next if($instance =~ /^cftgdg$/);
		next if($instance =~ /^cft$/);
		next if($instance =~ /^cft\w+r$/);
		next if($instance =~ /^cftbruc/);
		next if($instance =~ /^cftlabr/);
		next if($instance =~ /^cftmcad/);
		next if($instance =~ /^cftfrme/);
		next if($instance =~ /^cftrabe/);
		next if($instance =~ /^cftgale/);
		next if($instance =~ /^cftsidn/);
		next if($instance =~ /^cftaelo$/);
		my $code_rep = 0;
		Log("\nVerification $instance\n\n");
		if(CftRunning("$rep")) {
			if(HeureOk($HM0,$HM1)) {
				$code_rep = VerifProcess($instance);
				$code_rep = cftsur_controle($instance,$rep) if($code_rep==0);
			}
		} else {
			Log("    $instance ne tourne pas\n");
			$code_rep = 2;
		}
		if($code_rep==0) {
			Log("    $instance ok\n");
		} else {
			$code += $code_rep;
			Log("\n    Fichiers log de $instance:\n\n");
			for(CftLogs($rep)) {
				Log("\n        $_\n");
				my @result = tail("-15 $_");
				for(@result) {
					Log("      $_");
				}
			}
		}
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres :
# Definition du chemin d'acces
# Definition du user CFT
# Definition du partenaire CFT
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	if(@ARGV && $ARGV[0] eq "-log") {
		shift(@ARGV);
		$liste_log = 1;
	}
	my $nb = @ARGV;
	if($nb!=0 && $nb!=2) {
		Log("Erreur parametres @ARGV");
		return 1;
	} elsif($nb==2) {
		$HM0=shift(@ARGV);
		$HM1=shift(@ARGV);
	}
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
