#!/serveur/dp/bin/perl -w

# 	$Id: Brouillon.pl,v 2.0 2000/07/28 09:46:37 verdiemi Exp $	

# ---------------------------------------------------------------
#
# Vrification des log de la diffusion des fichiers brouillons.
#
# On vrifie qu'il n'y a pas trop d'erreur de diffusion.
#
# usage : Brouillon.pl <nom_template>
#
# Code retour :
#		0 : ok , 1 : erreur, 2 : alarme ITO
#
# exemple : Brouillon.pl Brouillon_sur
#
# ---------------------------------------------------------------

use strict;
require "ctime.pl";
use File::Basename;
use lib dirname($0);
use dits_def;

# ---------------------------------------------------------------
# 0: pas de trace, 1: traces
# ---------------------------------------------------------------
my $debug = Debug();

my($jour,$mois,$jmois,$heure,$type,$annee)= split(/\s+/,ctime(time()));
my $date = "$jour $mois $jmois";
my $log = "/export/home/disk1/ftpbdmt/log/log_diffusion_brouillon_erreur";
my $nb_erreur_max = 20;

# ---------------------------------------------------------------
# On compte le nombre de diffusion en erreur  la date du jour.
# ---------------------------------------------------------------
sub Traitement {
	Trace "Traitement" if($debug);
	my($compteur,$code,$ligne_prec) = (0,0,"");
	print("\nDiffusion des fichiers brouillons\n\n");
	print("  fichier log : $log\n");
	if(open(FP,"<$log")) {
		while(<FP>) {
			$compteur++ if (/non diffuse/ && $ligne_prec =~ /$date.*$annee/);
			$ligne_prec = $_;
		}
		close(FP);
		print "  $compteur erreur(s) detectee(s)\n\n";
		$code = 2 if($compteur>$nb_erreur_max);
	} else {
		print("  erreur open fichier log : $!\n\n");
		$code = 2;
	}
	return $code;
}

# ---------------------------------------------------------------
# lecture des parametres : aucun
# ---------------------------------------------------------------
sub LectureParametres {
	Trace "LectureParametres" if($debug);
	return 0;
}

# ---------------------------------------------------------------
# traitement commun a tous les templates ITO
# ---------------------------------------------------------------

Trace "@ARGV" if($debug);

# recuperation du nom de template, obligatoire pour ITO
my $NomTemplate=shift(@ARGV);

my $RetourITO = LectureParametres();
$RetourITO = Traitement() if($RetourITO == 0);

Trace "$NomTemplate=$RetourITO" if($debug);

# envoi du code retour a ITO via opcmon
if($NomTemplate eq "bidon") {
	exit $RetourITO;
} else {
	opcmon("$NomTemplate=$RetourITO");
	exit 0;
}

__END__
